/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.extension.bridge;

import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JavaValue;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.DoricContextManager;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.utils.DoricMetaInfo;
import pub.doric.utils.DoricUtils;

public class DoricBridgeExtension {
    public JavaValue callNative(String contextId, String module, String methodName, final String callbackId, final JSDecoder jsDecoder) {
        final DoricContext context = DoricContextManager.getContext(contextId);
        DoricMetaInfo<DoricJavaPlugin> pluginInfo = context.getDriver().getRegistry().acquirePluginInfo(module);
        if (pluginInfo == null) {
            context.getDriver().getRegistry().onLog(6, String.format("Cannot find plugin class:%s", module));
            return new JavaValue(false);
        }
        final DoricJavaPlugin doricJavaPlugin = context.obtainPlugin(pluginInfo);
        if (doricJavaPlugin == null) {
            context.getDriver().getRegistry().onLog(6, String.format("Cannot obtain plugin instance:%s,method:%s", module, methodName));
            return new JavaValue(false);
        }
        final Method method = pluginInfo.getMethod(methodName);
        if (method == null) {
            context.getDriver().getRegistry().onLog(6, String.format("Cannot find plugin method in class:%s,method:%s", module, methodName));
            return new JavaValue(false);
        }
        DoricMethod doricMethod = method.getAnnotation(DoricMethod.class);
        if (doricMethod == null) {
            context.getDriver().getRegistry().onLog(6, String.format("Cannot find DoricMethod annotation in class:%s,method:%s", module, methodName));
            return new JavaValue(false);
        }
        Callable<JavaValue> callable = new Callable<JavaValue>(){

            @Override
            public JavaValue call() throws Exception {
                Class<?>[] classes = method.getParameterTypes();
                Object ret = classes.length == 0 ? method.invoke((Object)doricJavaPlugin, new Object[0]) : (classes.length == 1 ? method.invoke((Object)doricJavaPlugin, DoricBridgeExtension.this.createParam(context, classes[0], callbackId, jsDecoder)) : method.invoke((Object)doricJavaPlugin, DoricBridgeExtension.this.createParam(context, classes[0], callbackId, jsDecoder), DoricBridgeExtension.this.createParam(context, classes[1], callbackId, jsDecoder)));
                return DoricUtils.toJavaValue(ret);
            }
        };
        AsyncResult<JavaValue> asyncResult = context.getDriver().asyncCall(callable, doricMethod.thread());
        asyncResult.setCallback(new AsyncResult.Callback<JavaValue>(){

            @Override
            public void onResult(JavaValue result) {
            }

            @Override
            public void onError(Throwable t) {
                context.getDriver().getRegistry().onException(context, t instanceof Exception ? (Exception)t : new RuntimeException(t));
            }

            @Override
            public void onFinish() {
            }
        });
        if (asyncResult.hasResult()) {
            return asyncResult.getResult();
        }
        return new JavaValue(true);
    }

    private Object createParam(DoricContext context, Class clz, String callbackId, JSDecoder jsDecoder) {
        if (clz == DoricPromise.class) {
            return new DoricPromise(context, callbackId);
        }
        try {
            return DoricUtils.toJavaObject(clz, jsDecoder);
        }
        catch (Exception e) {
            context.getDriver().getRegistry().onException(context, e);
            context.getDriver().getRegistry().onLog(6, String.format("createParam error:%s", e.getLocalizedMessage()));
            return null;
        }
    }
}

