/*
 * Decompiled with CFR 0.152.
 */
package pub.doric;

import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import pub.doric.DoricContext;
import pub.doric.utils.DoricUtils;

public class DoricPanel
extends FrameLayout
implements LifecycleObserver {
    private DoricContext mDoricContext;
    private FrameChangedListener frameChangedListener;
    private int renderedWidth = -1;
    private int renderedHeight = -1;

    public DoricPanel(@NonNull Context context) {
        this(context, null);
    }

    public DoricPanel(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DoricPanel(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.getContext() instanceof LifecycleOwner) {
            ((LifecycleOwner)this.getContext()).getLifecycle().addObserver((LifecycleObserver)this);
        }
    }

    public void config(String script, String alias, String extra) {
        DoricContext doricContext = DoricContext.create(this.getContext(), script, alias, extra);
        this.config(doricContext);
        if (this.getContext() instanceof LifecycleOwner && ((LifecycleOwner)this.getContext()).getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.RESUMED)) {
            doricContext.onShow();
        }
    }

    public void config(DoricContext doricContext) {
        this.mDoricContext = doricContext;
        this.mDoricContext.getRootNode().setRootView(this);
        if (this.getMeasuredWidth() != 0 || this.getMeasuredHeight() != 0) {
            this.mDoricContext.build(DoricUtils.px2dp(this.getMeasuredWidth()), DoricUtils.px2dp(this.getMeasuredHeight()));
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
    }

    public DoricContext getDoricContext() {
        return this.mDoricContext;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mDoricContext != null && (w != this.renderedWidth || h != this.renderedHeight)) {
            if (this.renderedWidth == oldw && this.renderedHeight == oldh) {
                if (this.frameChangedListener != null) {
                    this.frameChangedListener.onFrameChanged(w, h);
                }
                this.renderedWidth = w;
                this.renderedHeight = h;
            } else {
                this.mDoricContext.build(DoricUtils.px2dp(w), DoricUtils.px2dp(h));
                this.renderedWidth = w;
                this.renderedHeight = h;
            }
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onActivityResume() {
        if (this.mDoricContext != null) {
            this.mDoricContext.onShow();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onActivityPause() {
        if (this.mDoricContext != null) {
            this.mDoricContext.onHidden();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onActivityDestroy() {
        if (this.mDoricContext != null) {
            this.mDoricContext.teardown();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mDoricContext != null) {
            this.mDoricContext.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void setFrameChangedListener(FrameChangedListener listener) {
        this.frameChangedListener = listener;
    }

    public static interface FrameChangedListener {
        public void onFrameChanged(int var1, int var2);
    }
}

