/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.helper.PermissionHelper;

public class EasyPermissions {
    private static final String TAG = "EasyPermissions";

    public static boolean hasPermissions(Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        if (context == null) {
            throw new IllegalArgumentException("Can't check permissions for null context");
        }
        for (String perm : perms) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(@NonNull Activity host, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(host, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    public static void requestPermissions(@NonNull android.support.v4.app.Fragment host, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(host, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    public static void requestPermissions(@NonNull Fragment host, @NonNull String rationale, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(host, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    public static void requestPermissions(@NonNull Activity host, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(PermissionHelper.newInstance(host), rationale, positiveButton, negativeButton, requestCode, perms);
    }

    public static void requestPermissions(@NonNull android.support.v4.app.Fragment host, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(PermissionHelper.newInstance(host), rationale, positiveButton, negativeButton, requestCode, perms);
    }

    public static void requestPermissions(@NonNull Fragment host, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        EasyPermissions.requestPermissions(PermissionHelper.newInstance(host), rationale, positiveButton, negativeButton, requestCode, perms);
    }

    private static void requestPermissions(@NonNull PermissionHelper helper, @NonNull String rationale, @StringRes int positiveButton, @StringRes int negativeButton, int requestCode, String ... perms) {
        if (EasyPermissions.hasPermissions(helper.getContext(), perms)) {
            EasyPermissions.notifyAlreadyHasPermissions(helper.getHost(), requestCode, perms);
            return;
        }
        helper.requestPermissions(rationale, positiveButton, negativeButton, requestCode, perms);
    }

    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults, Object ... receivers) {
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String perm = permissions[i];
            if (grantResults[i] == 0) {
                granted.add(perm);
                continue;
            }
            denied.add(perm);
        }
        for (Object object : receivers) {
            if (!granted.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsGranted(requestCode, granted);
            }
            if (!denied.isEmpty() && object instanceof PermissionCallbacks) {
                ((PermissionCallbacks)object).onPermissionsDenied(requestCode, denied);
            }
            if (granted.isEmpty() || !denied.isEmpty()) continue;
            EasyPermissions.runAnnotatedMethods(object, requestCode);
        }
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Activity host, @NonNull List<String> deniedPermissions) {
        return PermissionHelper.newInstance(host).somePermissionPermanentlyDenied(deniedPermissions);
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull android.support.v4.app.Fragment host, @NonNull List<String> deniedPermissions) {
        return PermissionHelper.newInstance(host).somePermissionPermanentlyDenied(deniedPermissions);
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Fragment host, @NonNull List<String> deniedPermissions) {
        return PermissionHelper.newInstance(host).somePermissionPermanentlyDenied(deniedPermissions);
    }

    public static boolean permissionPermanentlyDenied(@NonNull Activity host, @NonNull String deniedPermission) {
        return PermissionHelper.newInstance(host).permissionPermanentlyDenied(deniedPermission);
    }

    public static boolean permissionPermanentlyDenied(@NonNull android.support.v4.app.Fragment host, @NonNull String deniedPermission) {
        return PermissionHelper.newInstance(host).permissionPermanentlyDenied(deniedPermission);
    }

    public static boolean permissionPermanentlyDenied(@NonNull Fragment host, @NonNull String deniedPermission) {
        return PermissionHelper.newInstance(host).permissionPermanentlyDenied(deniedPermission);
    }

    public static boolean somePermissionDenied(@NonNull Activity host, String ... perms) {
        return PermissionHelper.newInstance(host).somePermissionDenied(perms);
    }

    public static boolean somePermissionDenied(@NonNull android.support.v4.app.Fragment host, String ... perms) {
        return PermissionHelper.newInstance(host).somePermissionDenied(perms);
    }

    public static boolean somePermissionDenied(@NonNull Fragment host, String ... perms) {
        return PermissionHelper.newInstance(host).somePermissionDenied(perms);
    }

    private static void notifyAlreadyHasPermissions(@NonNull Object object, int requestCode, @NonNull String[] perms) {
        int[] grantResults = new int[perms.length];
        for (int i = 0; i < perms.length; ++i) {
            grantResults[i] = 0;
        }
        EasyPermissions.onRequestPermissionsResult(requestCode, perms, grantResults, object);
    }

    private static void runAnnotatedMethods(@NonNull Object object, int requestCode) {
        Class<?> clazz = object.getClass();
        if (EasyPermissions.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                AfterPermissionGranted ann;
                if (!method.isAnnotationPresent(AfterPermissionGranted.class) || (ann = method.getAnnotation(AfterPermissionGranted.class)).value() != requestCode) continue;
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Cannot execute method " + method.getName() + " because it is non-void method and/or has input parameters.");
                }
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static boolean isUsingAndroidAnnotations(@NonNull Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsGranted(int var1, List<String> var2);

        public void onPermissionsDenied(int var1, List<String> var2);
    }
}

