package pro.siper.adept.core

import android.util.SparseArray
import android.view.View
import androidx.recyclerview.widget.RecyclerView

class AdeptViewHolder(itemView: View, val viewType: Int) : RecyclerView.ViewHolder(itemView) {
    private val views = SparseArray<View>()

    @Suppress("UNCHECKED_CAST")
    fun <T: View> findView(id: Int): T {
        if (views[id] == null) {
            views.put(id, itemView.findViewById(id))
        }
        return views[id] as T
    }
}