/*
 * Decompiled with CFR 0.152.
 */
package pro.siper.adept.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import pro.siper.adept.core.AdeptViewHolder;
import pro.siper.adept.core.ItemViewRenderer;
import pro.siper.adept.core.ViewBinder;
import pro.siper.adept.core.diff.DefaultDiffUtilCallback;
import pro.siper.adept.core.diff.DiffUtilCallback;
import pro.siper.adept.core.diff.DiffUtilCallbackCreator;
import pro.siper.adept.core.endless.EndlessScrollingCallback;
import pro.siper.adept.core.endless.EndlessScrollingListener;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003JS\u0010!\u001a\u00020\u0000\"\u0006\b\u0000\u0010\"\u0018\u00012\u0006\u0010#\u001a\u00020\u000528\b\u0004\u0010$\u001a2\u0012\u0013\u0012\u0011H\"\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+0%H\u0086\bJ'\u0010!\u001a\u00020\u0000\"\u0006\b\u0000\u0010\"\u0018\u00012\u0006\u0010#\u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\u0016H\u0086\bJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020\u0005H\u0016J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0016J\u0010\u00102\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0005H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0005H\u0016J\u0010\u00109\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010:\u001a\u00020+2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0;J\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\fJH\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0014\u001a\u00020\u000526\u0010<\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(=\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(>\u0012\u0004\u0012\u00020\u00190%J\u0018\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0014\u001a\u00020\u00052\u0006\u0010<\u001a\u00020?R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u0015\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u001c\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lpro/siper/adept/core/Adept;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lpro/siper/adept/core/AdeptViewHolder;", "()V", "LOADING_VIEW", "", "dataset", "", "", "getDataset", "()Ljava/util/List;", "diffUtilCallback", "Lpro/siper/adept/core/diff/DiffUtilCallback;", "endlessScrollingListener", "Lpro/siper/adept/core/endless/EndlessScrollingListener;", "layouts", "", "Lkotlin/reflect/KClass;", "getLayouts", "()Ljava/util/Map;", "loadingLayoutResId", "renderers", "Lpro/siper/adept/core/ItemViewRenderer;", "getRenderers", "useDiffUtil", "", "getUseDiffUtil", "()Z", "useEndlessScrolling", "getUseEndlessScrolling", "useLoadingView", "getUseLoadingView", "viewTypes", "addRenderer", "T", "layoutId", "renderer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "data", "Lpro/siper/adept/core/ViewBinder;", "viewBinder", "", "attachTo", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getItemCount", "getItemViewType", "position", "onAttachedToRecyclerView", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onDetachedFromRecyclerView", "updateDataset", "", "endlessScrollingCallback", "currentPage", "totalItemsCount", "Lpro/siper/adept/core/endless/EndlessScrollingCallback;", "adept-core_release"})
public final class Adept
extends RecyclerView.Adapter<AdeptViewHolder> {
    @NotNull
    private final Map<KClass<?>, ItemViewRenderer<?>> renderers;
    @NotNull
    private final Map<KClass<?>, Integer> layouts;
    @NotNull
    private final List<Object> dataset;
    private final int LOADING_VIEW = -11;
    private final List<KClass<? extends Object>> viewTypes;
    private DiffUtilCallback diffUtilCallback;
    private EndlessScrollingListener endlessScrollingListener;
    private int loadingLayoutResId;

    @NotNull
    public final Map<KClass<?>, ItemViewRenderer<?>> getRenderers() {
        return this.renderers;
    }

    @NotNull
    public final Map<KClass<?>, Integer> getLayouts() {
        return this.layouts;
    }

    @NotNull
    public final List<Object> getDataset() {
        return this.dataset;
    }

    private final boolean getUseDiffUtil() {
        return this.diffUtilCallback != null;
    }

    private final boolean getUseEndlessScrolling() {
        return this.endlessScrollingListener != null;
    }

    private final boolean getUseLoadingView() {
        return this.loadingLayoutResId != -1;
    }

    public int getItemViewType(int position) {
        KClass type;
        if (position == this.getItemCount() - 1 && this.getUseLoadingView()) {
            return this.LOADING_VIEW;
        }
        Object object = this.dataset.get(position);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if (this.viewTypes.indexOf(type = Reflection.getOrCreateKotlinClass(object.getClass())) == -1) {
            this.viewTypes.add((KClass<? extends Object>)type);
        }
        return this.viewTypes.indexOf(type);
    }

    @NotNull
    public AdeptViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View view;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        if (this.getUseLoadingView() && viewType == this.LOADING_VIEW) {
            View view2;
            View view3 = view2 = LayoutInflater.from((Context)parent.getContext()).inflate(this.loadingLayoutResId, parent, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view");
            return new AdeptViewHolder(view3, viewType);
        }
        Integer n = this.layouts.get(this.viewTypes.get(viewType));
        if (n == null) {
            throw (Throwable)new IllegalArgumentException("Layout for " + this.viewTypes.get(viewType) + " is not registered");
        }
        int layout = n;
        View view4 = view = LayoutInflater.from((Context)parent.getContext()).inflate(layout, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"view");
        return new AdeptViewHolder(view4, viewType);
    }

    public int getItemCount() {
        return this.getUseLoadingView() ? this.dataset.size() + 1 : this.dataset.size();
    }

    public void onBindViewHolder(@NotNull AdeptViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        if (this.getUseLoadingView() && holder.getViewType() == this.LOADING_VIEW) {
            return;
        }
        ItemViewRenderer<?> itemViewRenderer = this.renderers.get(this.viewTypes.get(holder.getViewType()));
        if (itemViewRenderer == null) {
            throw (Throwable)new IllegalArgumentException("There are no renderer for " + this.viewTypes.get(holder.getViewType()));
        }
        ItemViewRenderer<?> renderer = itemViewRenderer;
        renderer.anyTypeRender$adept_core_release(this.dataset.get(position), new ViewBinder(holder));
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onAttachedToRecyclerView(recyclerView);
        if (this.getUseEndlessScrolling()) {
            EndlessScrollingListener endlessScrollingListener = this.endlessScrollingListener;
            if (endlessScrollingListener == null) {
                Intrinsics.throwNpe();
            }
            recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)endlessScrollingListener);
        }
    }

    public void onDetachedFromRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onDetachedFromRecyclerView(recyclerView);
        if (this.getUseEndlessScrolling()) {
            EndlessScrollingListener endlessScrollingListener = this.endlessScrollingListener;
            if (endlessScrollingListener == null) {
                Intrinsics.throwNpe();
            }
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)endlessScrollingListener);
        }
    }

    public final void updateDataset(@NotNull List<? extends Object> dataset) {
        Intrinsics.checkParameterIsNotNull(dataset, (String)"dataset");
        if (this.getUseDiffUtil()) {
            DiffUtilCallback diffUtilCallback = this.diffUtilCallback;
            if (diffUtilCallback == null) {
                Intrinsics.throwNpe();
            }
            DiffUtilCallbackCreator diff = new DiffUtilCallbackCreator(this.dataset, dataset, diffUtilCallback);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diff);
            this.dataset.clear();
            this.dataset.addAll((Collection<Object>)dataset);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
        } else {
            this.dataset.clear();
            this.dataset.addAll((Collection<Object>)dataset);
        }
    }

    private final <T> Adept addRenderer(int layoutId, ItemViewRenderer<T> renderer) {
        Map<KClass<?>, Integer> map = this.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (map.containsKey(Reflection.getOrCreateKotlinClass(Object.class))) {
            StringBuilder stringBuilder = new StringBuilder().append("Renderer for ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw (Throwable)new IllegalArgumentException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class)).append(" already registered").toString());
        }
        Map<KClass<?>, Object> map2 = this.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        Object object = layoutId;
        map2.put(kClass, (Integer)object);
        map2 = this.getRenderers();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        kClass = Reflection.getOrCreateKotlinClass(Object.class);
        object = renderer;
        map2.put(kClass, (Integer)object);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Adept addRenderer(int layoutId, Function2<? super T, ? super ViewBinder, Unit> renderer) {
        void this_$iv;
        Adept adept = this;
        Intrinsics.needClassReification();
        ItemViewRenderer renderer$iv = new ItemViewRenderer<T>(renderer){
            final /* synthetic */ Function2 $renderer;

            public void render(T data, @NotNull ViewBinder viewBinder) {
                Intrinsics.checkParameterIsNotNull((Object)viewBinder, (String)"viewBinder");
                this.$renderer.invoke(data, (Object)viewBinder);
            }
            {
                this.$renderer = $captured_local_variable$0;
            }
        };
        Map<KClass<?>, Integer> map = this_$iv.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (map.containsKey(Reflection.getOrCreateKotlinClass(Object.class))) {
            StringBuilder stringBuilder = new StringBuilder().append("Renderer for ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw (Throwable)new IllegalArgumentException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class)).append(" already registered").toString());
        }
        Map<KClass<?>, Object> map2 = this_$iv.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        Object object = layoutId;
        map2.put(kClass, (Integer)object);
        map2 = this_$iv.getRenderers();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        kClass = Reflection.getOrCreateKotlinClass(Object.class);
        object = renderer$iv;
        map2.put(kClass, (Integer)object);
        return this;
    }

    @NotNull
    public final Adept attachTo(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        recyclerView.setAdapter((RecyclerView.Adapter)this);
        return this;
    }

    @NotNull
    public final Adept useDiffUtil(@NotNull DiffUtilCallback diffUtilCallback) {
        Intrinsics.checkParameterIsNotNull((Object)diffUtilCallback, (String)"diffUtilCallback");
        this.diffUtilCallback = diffUtilCallback;
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Adept useDiffUtil$default(Adept adept, DiffUtilCallback diffUtilCallback, int n, Object object) {
        if ((n & 1) != 0) {
            diffUtilCallback = DefaultDiffUtilCallback.INSTANCE;
        }
        return adept.useDiffUtil(diffUtilCallback);
    }

    @NotNull
    public final Adept useEndlessScrolling(int loadingLayoutResId, @NotNull EndlessScrollingCallback endlessScrollingCallback) {
        Intrinsics.checkParameterIsNotNull((Object)endlessScrollingCallback, (String)"endlessScrollingCallback");
        this.loadingLayoutResId = loadingLayoutResId;
        this.endlessScrollingListener = new EndlessScrollingListener(endlessScrollingCallback);
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Adept useEndlessScrolling$default(Adept adept, int n, EndlessScrollingCallback endlessScrollingCallback, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return adept.useEndlessScrolling(n, endlessScrollingCallback);
    }

    @NotNull
    public final Adept useEndlessScrolling(int loadingLayoutResId, @NotNull Function2<? super Integer, ? super Integer, Boolean> endlessScrollingCallback) {
        Intrinsics.checkParameterIsNotNull(endlessScrollingCallback, (String)"endlessScrollingCallback");
        this.useEndlessScrolling(loadingLayoutResId, new EndlessScrollingCallback(endlessScrollingCallback){
            final /* synthetic */ Function2 $endlessScrollingCallback;

            public boolean onLoadMore(int currentPage, int totalItemsCount) {
                return (Boolean)this.$endlessScrollingCallback.invoke((Object)currentPage, (Object)totalItemsCount);
            }
            {
                this.$endlessScrollingCallback = $captured_local_variable$0;
            }
        });
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Adept useEndlessScrolling$default(Adept adept, int n, Function2 function2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return adept.useEndlessScrolling(n, (Function2<? super Integer, ? super Integer, Boolean>)function2);
    }

    public Adept() {
        Adept adept = this;
        Object object = new LinkedHashMap();
        adept.renderers = object;
        adept = this;
        object = new LinkedHashMap();
        adept.layouts = object;
        adept = this;
        adept.dataset = object = (List)new ArrayList();
        this.LOADING_VIEW = -11;
        adept = this;
        adept.viewTypes = object = (List)new ArrayList();
        this.loadingLayoutResId = -1;
    }
}

