/*
 * Decompiled with CFR 0.152.
 */
package pro.siper.adept.core;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import pro.siper.adept.core.AdeptViewHolder;
import pro.siper.adept.core.ItemViewRenderer;
import pro.siper.adept.core.ViewBinder;
import pro.siper.adept.core.diff.DefaultDiffUtilCallback;
import pro.siper.adept.core.diff.DiffUtilCallback;
import pro.siper.adept.core.diff.DiffUtilCallbackCreator;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003JS\u0010\u0015\u001a\u00020\u0000\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u0006\u0010\u0017\u001a\u00020\f28\b\u0004\u0010\u0018\u001a2\u0012\u0013\u0012\u0011H\u0016\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001f0\u0019H\u0086\bJ'\u0010\u0015\u001a\u00020\u0000\"\u0006\b\u0000\u0010\u0016\u0018\u00012\u0006\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0010H\u0086\bJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\fH\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\fH\u0016J\u0016\u0010,\u001a\u00020\u001f2\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060-J\u0010\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR%\u0010\u000f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lpro/siper/adept/core/Adept;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lpro/siper/adept/core/AdeptViewHolder;", "()V", "dataset", "", "", "diffUtilCallback", "Lpro/siper/adept/core/diff/DiffUtilCallback;", "layouts", "", "Lkotlin/reflect/KClass;", "", "getLayouts", "()Ljava/util/Map;", "renderers", "Lpro/siper/adept/core/ItemViewRenderer;", "getRenderers", "useDiffUtil", "", "viewTypes", "addRenderer", "T", "layoutId", "renderer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "data", "Lpro/siper/adept/core/ViewBinder;", "viewBinder", "", "attachTo", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getItemCount", "getItemViewType", "position", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "updateDataset", "", "adept-core_release"})
public final class Adept
extends RecyclerView.Adapter<AdeptViewHolder> {
    @NotNull
    private final Map<KClass<?>, ItemViewRenderer<?>> renderers;
    @NotNull
    private final Map<KClass<?>, Integer> layouts;
    private final List<Object> dataset;
    private final List<KClass<? extends Object>> viewTypes;
    private boolean useDiffUtil;
    private DiffUtilCallback diffUtilCallback;

    @NotNull
    public final Map<KClass<?>, ItemViewRenderer<?>> getRenderers() {
        return this.renderers;
    }

    @NotNull
    public final Map<KClass<?>, Integer> getLayouts() {
        return this.layouts;
    }

    public int getItemViewType(int position) {
        KClass type;
        Object object = this.dataset.get(position);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if (this.viewTypes.indexOf(type = Reflection.getOrCreateKotlinClass(object.getClass())) == -1) {
            this.viewTypes.add((KClass<? extends Object>)type);
        }
        return this.viewTypes.indexOf(type);
    }

    @NotNull
    public AdeptViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View view;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Integer n = this.layouts.get(this.viewTypes.get(viewType));
        if (n == null) {
            throw (Throwable)new IllegalArgumentException("Layout for this data type is not registered");
        }
        int layout = n;
        View view2 = view = LayoutInflater.from((Context)parent.getContext()).inflate(layout, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
        return new AdeptViewHolder(view2, viewType);
    }

    public int getItemCount() {
        return this.dataset.size();
    }

    public void onBindViewHolder(@NotNull AdeptViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        ItemViewRenderer<?> itemViewRenderer = this.renderers.get(this.viewTypes.get(holder.getViewType()));
        if (itemViewRenderer == null) {
            throw (Throwable)new IllegalArgumentException("There is no renderer for this data type");
        }
        ItemViewRenderer<?> renderer = itemViewRenderer;
        renderer.anyTypeRender$adept_core_release(this.dataset.get(position), new ViewBinder(holder));
    }

    public final void updateDataset(@NotNull List<? extends Object> dataset) {
        Intrinsics.checkParameterIsNotNull(dataset, (String)"dataset");
        if (this.useDiffUtil) {
            DiffUtilCallbackCreator diff = new DiffUtilCallbackCreator(this.dataset, dataset, this.diffUtilCallback);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diff);
            this.dataset.clear();
            this.dataset.addAll((Collection<Object>)dataset);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
        } else {
            this.dataset.clear();
            this.dataset.addAll((Collection<Object>)dataset);
        }
    }

    private final <T> Adept addRenderer(int layoutId, ItemViewRenderer<T> renderer) {
        Map<KClass<?>, Integer> map = this.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (map.containsKey(Reflection.getOrCreateKotlinClass(Object.class))) {
            throw (Throwable)new IllegalArgumentException("Renderer for this data type already registered");
        }
        Map<KClass<?>, Object> map2 = this.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        Object object = layoutId;
        map2.put(kClass, (Integer)object);
        map2 = this.getRenderers();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        kClass = Reflection.getOrCreateKotlinClass(Object.class);
        object = renderer;
        map2.put(kClass, (Integer)object);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Adept addRenderer(int layoutId, Function2<? super T, ? super ViewBinder, Unit> renderer) {
        void this_$iv;
        Adept adept = this;
        Intrinsics.needClassReification();
        ItemViewRenderer renderer$iv = new ItemViewRenderer<T>(renderer){
            final /* synthetic */ Function2 $renderer;

            public void render(T data, @NotNull ViewBinder viewBinder) {
                Intrinsics.checkParameterIsNotNull((Object)viewBinder, (String)"viewBinder");
                this.$renderer.invoke(data, (Object)viewBinder);
            }
            {
                this.$renderer = $captured_local_variable$0;
            }
        };
        Map<KClass<?>, Integer> map = this_$iv.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (map.containsKey(Reflection.getOrCreateKotlinClass(Object.class))) {
            throw (Throwable)new IllegalArgumentException("Renderer for this data type already registered");
        }
        Map<KClass<?>, Object> map2 = this_$iv.getLayouts();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        Object object = layoutId;
        map2.put(kClass, (Integer)object);
        map2 = this_$iv.getRenderers();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        kClass = Reflection.getOrCreateKotlinClass(Object.class);
        object = renderer$iv;
        map2.put(kClass, (Integer)object);
        return this;
    }

    @NotNull
    public final Adept attachTo(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        recyclerView.setAdapter((RecyclerView.Adapter)this);
        return this;
    }

    @NotNull
    public final Adept useDiffUtil(@NotNull DiffUtilCallback diffUtilCallback) {
        Intrinsics.checkParameterIsNotNull((Object)diffUtilCallback, (String)"diffUtilCallback");
        this.diffUtilCallback = diffUtilCallback;
        this.useDiffUtil = true;
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Adept useDiffUtil$default(Adept adept, DiffUtilCallback diffUtilCallback, int n, Object object) {
        if ((n & 1) != 0) {
            diffUtilCallback = DefaultDiffUtilCallback.INSTANCE;
        }
        return adept.useDiffUtil(diffUtilCallback);
    }

    public Adept() {
        Adept adept = this;
        Object object = new LinkedHashMap();
        adept.renderers = object;
        adept = this;
        object = new LinkedHashMap();
        adept.layouts = object;
        adept = this;
        adept.dataset = object = (List)new ArrayList();
        adept = this;
        adept.viewTypes = object = (List)new ArrayList();
        this.diffUtilCallback = DefaultDiffUtilCallback.INSTANCE;
    }
}

