/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.TypeNode;
import net.sourceforge.pmd.typeresolution.PMDASMClassLoader;

public class ClassTypeResolver
extends JavaParserVisitorAdapter {
    private static final Logger LOG;
    private static Map<String, Class> myPrimitiveTypes;
    private static Map<String, String> myJavaLang;
    private static PMDASMClassLoader pmdClassLoader;
    private Map<String, String> importedClasses;
    private List<String> importedOnDemand;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTImportDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$typeresolution$ClassTypeResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ASTCompilationUnit node, Object data) {
        String className = null;
        try {
            this.importedOnDemand = new ArrayList<String>();
            className = this.getClassName(node);
            if (className != null) {
                this.populateClassName(node, className);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.FINE, "Could not find class " + className);
        }
        catch (NoClassDefFoundError e) {
            LOG.log(Level.WARNING, "Could not find class " + className);
        }
        finally {
            this.populateImports(node);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        ASTName importedType = (ASTName)node.jjtGetChild(0);
        if (importedType.getType() != null) {
            node.setType(importedType.getType());
        } else {
            this.populateType(node, importedType.getImage());
        }
        if (node.getType() != null) {
            node.setPackage(node.getType().getPackage());
        }
        return data;
    }

    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.populateType(node, node.getImage());
        return data;
    }

    public Object visit(ASTName node, Object data) {
        if (node.getNameDeclaration() == null) {
            String name = node.getImage();
            if (name.indexOf(46) != -1) {
                name = name.substring(0, name.indexOf(46));
            }
            this.populateType(node, name);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node == null || node.getNameDeclaration() == null) {
            return super.visit(node, data);
        }
        String name = node.getNameDeclaration().getTypeImage();
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.indexOf(46));
        }
        this.populateType(node, name);
        return super.visit(node, data);
    }

    private void populateType(TypeNode node, String className) {
        String qualifiedName = className;
        Class myType = myPrimitiveTypes.get(className);
        if (myType == null && this.importedClasses != null) {
            if (this.importedClasses.containsKey(className)) {
                qualifiedName = this.importedClasses.get(className);
            } else if (this.importedClasses.containsValue(className)) {
                qualifiedName = className;
            }
            if (qualifiedName != null) {
                try {
                    myType = pmdClassLoader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException e) {
                    myType = this.processOnDemand(qualifiedName);
                }
            }
        }
        if (myType != null) {
            node.setType(myType);
        }
    }

    public static boolean classNameExists(String fullyQualifiedClassName) {
        try {
            pmdClassLoader.loadClass(fullyQualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Class processOnDemand(String qualifiedName) {
        Iterator<String> i$ = this.importedOnDemand.iterator();
        while (i$.hasNext()) {
            String entry = i$.next();
            try {
                return pmdClassLoader.loadClass(entry + "." + qualifiedName);
            }
            catch (Throwable e) {
            }
        }
        return null;
    }

    private String getClassName(ASTCompilationUnit node) {
        ASTClassOrInterfaceDeclaration classDecl;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
        }
        if ((classDecl = (ASTClassOrInterfaceDeclaration)node.getFirstChildOfType(clazz)) == null) {
            return null;
        }
        if (node.declarationsAreInDefaultPackage()) {
            return classDecl.getImage();
        }
        ASTPackageDeclaration pkgDecl = node.getPackageDeclaration();
        this.importedOnDemand.add(pkgDecl.getPackageNameImage());
        return pkgDecl.getPackageNameImage() + "." + classDecl.getImage();
    }

    private void populateImports(ASTCompilationUnit node) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTImportDeclaration = new ASTImportDeclaration[0].getClass().getComponentType();
        }
        List theImportDeclarations = node.findChildrenOfType(clazz);
        this.importedClasses = new HashMap<String, String>();
        Iterator i$ = theImportDeclarations.iterator();
        while (i$.hasNext()) {
            ASTImportDeclaration anImportDeclaration = (ASTImportDeclaration)i$.next();
            String strPackage = anImportDeclaration.getPackageName();
            if (anImportDeclaration.isImportOnDemand()) {
                this.importedOnDemand.add(strPackage);
                continue;
            }
            if (anImportDeclaration.isImportOnDemand()) continue;
            String strName = anImportDeclaration.getImportedName();
            this.importedClasses.put(strName, strName);
            this.importedClasses.put(strName.substring(strPackage.length() + 1), strName);
        }
        this.importedClasses.putAll(myJavaLang);
    }

    private void populateClassName(ASTCompilationUnit node, String className) throws ClassNotFoundException {
        node.setType(pmdClassLoader.loadClass(className));
        this.importedClasses = pmdClassLoader.getImportedClasses(className);
    }

    static {
        Class<?> clazz = class$net$sourceforge$pmd$typeresolution$ClassTypeResolver;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$typeresolution$ClassTypeResolver = new ClassTypeResolver[0].getClass().getComponentType();
        }
        LOG = Logger.getLogger(clazz.getName());
        pmdClassLoader = new PMDASMClassLoader();
        HashMap<String, Class<Object>> thePrimitiveTypes = new HashMap<String, Class<Object>>();
        thePrimitiveTypes.put("short", Short.TYPE);
        thePrimitiveTypes.put("byte", Byte.TYPE);
        thePrimitiveTypes.put("char", Character.TYPE);
        thePrimitiveTypes.put("int", Integer.TYPE);
        thePrimitiveTypes.put("long", Long.TYPE);
        thePrimitiveTypes.put("float", Float.TYPE);
        thePrimitiveTypes.put("double", Double.TYPE);
        thePrimitiveTypes.put("boolean", Boolean.TYPE);
        thePrimitiveTypes.put("void", Void.TYPE);
        myPrimitiveTypes = Collections.unmodifiableMap(thePrimitiveTypes);
        myJavaLang = new HashMap<String, String>();
        myJavaLang.put("Boolean", "java.lang.Boolean");
        myJavaLang.put("Byte", "java.lang.Byte");
        myJavaLang.put("Character", "java.lang.Character");
        myJavaLang.put("CharSequence", "java.lang.CharSequence");
        myJavaLang.put("Class", "java.lang.Class");
        myJavaLang.put("ClassLoader", "java.lang.ClassLoader");
        myJavaLang.put("Cloneable", "java.lang.Cloneable");
        myJavaLang.put("Comparable", "java.lang.Comparable");
        myJavaLang.put("Compiler", "java.lang.Compiler");
        myJavaLang.put("Double", "java.lang.Double");
        myJavaLang.put("Float", "java.lang.Float");
        myJavaLang.put("InheritableThreadLocal", "java.lang.InheritableThreadLocal");
        myJavaLang.put("Integer", "java.lang.Integer");
        myJavaLang.put("Long", "java.lang.Long");
        myJavaLang.put("Math", "java.lang.Math");
        myJavaLang.put("Number", "java.lang.Number");
        myJavaLang.put("Object", "java.lang.Object");
        myJavaLang.put("Package", "java.lang.Package");
        myJavaLang.put("Process", "java.lang.Process");
        myJavaLang.put("Runnable", "java.lang.Runnable");
        myJavaLang.put("Runtime", "java.lang.Runtime");
        myJavaLang.put("RuntimePermission", "java.lang.RuntimePermission");
        myJavaLang.put("SecurityManager", "java.lang.SecurityManager");
        myJavaLang.put("Short", "java.lang.Short");
        myJavaLang.put("StackTraceElement", "java.lang.StackTraceElement");
        myJavaLang.put("StrictMath", "java.lang.StrictMath");
        myJavaLang.put("String", "java.lang.String");
        myJavaLang.put("StringBuffer", "java.lang.StringBuffer");
        myJavaLang.put("System", "java.lang.System");
        myJavaLang.put("Thread", "java.lang.Thread");
        myJavaLang.put("ThreadGroup", "java.lang.ThreadGroup");
        myJavaLang.put("ThreadLocal", "java.lang.ThreadLocal");
        myJavaLang.put("Throwable", "java.lang.Throwable");
        myJavaLang.put("Void", "java.lang.Void");
    }
}

