/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.junit;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTExtendsList;
import net.sourceforge.pmd.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.ast.ASTTypeParameters;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.typeresolution.TypeHelper;

public abstract class AbstractJUnitRule
extends AbstractRule {
    public static Class junit4Class = null;
    public static Class junit3Class = null;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMarkerAnnotation;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTExtendsList;

    public Object visit(ASTCompilationUnit node, Object data) {
        boolean isJunit3Class = this.isJUnit3Class(node);
        boolean isJunit4Class = this.isJUnit4Class(node);
        if (isJunit3Class || isJunit4Class) {
            return super.visit(node, data);
        }
        return data;
    }

    public boolean isJUnitMethod(ASTMethodDeclaration method, Object data) {
        if (!method.isPublic() || method.isAbstract() || method.isNative() || method.isStatic()) {
            return false;
        }
        Node node = method.jjtGetChild(0);
        if (node instanceof ASTTypeParameters) {
            node = method.jjtGetChild(1);
        }
        return ((ASTResultType)node).isVoid() && method.getMethodName().startsWith("test");
    }

    public boolean isJUnit4Method() {
        return false;
    }

    public boolean isJUnit3Class(ASTCompilationUnit node) {
        if (node.getType() != null && TypeHelper.isA(node, junit3Class)) {
            return true;
        }
        if (node.getType() == null) {
            ASTExtendsList extendsList;
            ASTClassOrInterfaceDeclaration cid;
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceDeclaration = new ASTClassOrInterfaceDeclaration[0].getClass().getComponentType();
            }
            if ((cid = (ASTClassOrInterfaceDeclaration)node.getFirstChildOfType(clazz)) == null) {
                return false;
            }
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTExtendsList;
            if (clazz2 == null) {
                clazz2 = class$net$sourceforge$pmd$ast$ASTExtendsList = new ASTExtendsList[0].getClass().getComponentType();
            }
            if ((extendsList = (ASTExtendsList)cid.getFirstChildOfType(clazz2)) == null) {
                return false;
            }
            if (((ASTClassOrInterfaceType)extendsList.jjtGetChild(0)).getImage().endsWith("TestCase")) {
                return true;
            }
            String className = cid.getImage();
            return className.endsWith("Test");
        }
        return false;
    }

    public boolean isJUnit4Class(ASTCompilationUnit node) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTMarkerAnnotation;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTMarkerAnnotation = new ASTMarkerAnnotation[0].getClass().getComponentType();
        }
        List lstAnnotations = node.findChildrenOfType(clazz);
        Iterator i$ = lstAnnotations.iterator();
        while (i$.hasNext()) {
            ASTName name;
            ASTMarkerAnnotation annotation = (ASTMarkerAnnotation)i$.next();
            if (!(annotation.getType() == null ? "Test".equals((name = (ASTName)annotation.jjtGetChild(0)).getImage()) : annotation.getType().equals(junit4Class))) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            junit4Class = Class.forName("org.junit.Test");
        }
        catch (Throwable t) {
            junit4Class = null;
        }
        try {
            junit3Class = Class.forName("junit.framework.TestCase");
        }
        catch (Throwable t) {
            junit3Class = null;
        }
    }
}

