/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.util.Benchmark;
import net.sourceforge.retroweaver.runtime.java.lang.System_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSet {
    private List<Rule> rules = new ArrayList<Rule>();
    private String name = "";
    private String description = "";
    private Language language;

    public int size() {
        return this.rules.size();
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new RuntimeException("Null Rule reference added to a RuleSet; that's a bug somewhere in PMD");
        }
        this.rules.add(rule);
    }

    public Collection<Rule> getRules() {
        return this.rules;
    }

    public boolean usesDFA() {
        for (Rule r : this.rules) {
            if (!r.usesDFA()) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        Rule rule = null;
        Iterator<Rule> i = this.rules.iterator();
        while (i.hasNext() && rule == null) {
            Rule r = i.next();
            if (!r.getName().equals(ruleName)) continue;
            rule = r;
        }
        return rule;
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.rules.addAll(this.rules.size(), ruleSet.getRules());
    }

    public void apply(List acuList, RuleContext ctx) {
        long start = System_.nanoTime();
        for (Rule rule : this.rules) {
            if (rule.usesRuleChain()) continue;
            rule.apply(acuList, ctx);
            long end = System_.nanoTime();
            Benchmark.mark(0, rule.getName(), end - start, 1L);
            start = end;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RuleSet)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RuleSet ruleSet = (RuleSet)o;
        return this.getName().equals(ruleSet.getName()) && ((Object)this.getRules()).equals(ruleSet.getRules());
    }

    public int hashCode() {
        return this.getName().hashCode() + 13 * ((Object)this.getRules()).hashCode();
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean usesTypeResolution() {
        for (Rule r : this.rules) {
            if (!r.usesTypeResolution()) continue;
            return true;
        }
        return false;
    }
}

