/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractZipArchiver
extends AbstractArchiver {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private String comment;
    private String encoding;
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    protected String archiveType = "zip";
    private boolean keepCompression = false;
    private int fileMode = 33188;
    private int dirMode = 16877;
    private boolean doFilesonly = false;
    protected Hashtable entries = new Hashtable();
    protected String duplicate = "add";
    protected Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    protected boolean addingNewFiles = false;
    private boolean roundUp = true;

    protected final void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix, int dirMode) throws IOException {
        if (!this.doFilesonly) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length();
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.get(String.valueOf(prefix) + dir) != null) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f = null;
                f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                this.zipDir(f, zOut, String.valueOf(prefix) + dir, dirMode);
            }
        }
    }

    protected final void addResources(Map resources, ZipOutputStream zOut) throws IOException, ArchiverException {
        File base = null;
        Iterator iter = resources.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            File resource = (File)resources.get(name);
            if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
            if (resource.isDirectory() && !name.endsWith("/")) {
                name = String.valueOf(name) + "/";
            }
            this.addParentDirs(base, name, zOut, "", this.dirMode);
            this.zipFile(resource, zOut, name, this.fileMode);
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
    }

    public void createArchive() throws ArchiverException, IOException {
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.createArchiveMain();
            this.skipWriting = false;
            this.createArchiveMain();
        } else {
            this.createArchiveMain();
        }
    }

    private void createArchiveMain() throws ArchiverException, IOException {
        File zipFile;
        Map listFiles = this.getFiles();
        if (listFiles == null || listFiles.size() == 0) {
            new ArchiverException("You must set at least one file.");
        }
        if ((zipFile = this.getDestFile()) == null) {
            new ArchiverException("You must set the destination " + this.archiveType + "file.");
        }
        if (zipFile.exists() && !zipFile.isFile()) {
            new ArchiverException(String.valueOf(String.valueOf(zipFile)) + " isn't a file.");
        }
        if (zipFile.exists() && !zipFile.canWrite()) {
            new ArchiverException(String.valueOf(String.valueOf(zipFile)) + " is read-only.");
        }
        File renamedFile = null;
        this.addingNewFiles = true;
        if (this.doUpdate && !zipFile.exists()) {
            this.doUpdate = false;
            this.getLogger().debug("ignoring update attribute as " + this.archiveType + " doesn't exist.");
        }
        boolean success = false;
        try {
            try {
                if (this.doUpdate) {
                    renamedFile = FileUtils.createTempFile((String)"zip", (String)".tmp", (File)zipFile.getParentFile());
                    renamedFile.deleteOnExit();
                    try {
                        FileUtils.rename((File)zipFile, (File)renamedFile);
                    }
                    catch (SecurityException e) {
                        this.getLogger().debug(e.toString());
                        throw new ArchiverException("Not allowed to rename old file (" + zipFile.getAbsolutePath() + ") to temporary file", e);
                    }
                    catch (IOException e) {
                        this.getLogger().debug(e.toString());
                        throw new ArchiverException("Unable to rename old file (" + zipFile.getAbsolutePath() + ") to temporary file", e);
                    }
                }
                String action = this.doUpdate ? "Updating " : "Building ";
                this.getLogger().info(String.valueOf(action) + this.archiveType + ": " + zipFile.getAbsolutePath());
                ZipOutputStream zOut = null;
                try {
                    if (!this.skipWriting) {
                        zOut = new ZipOutputStream(zipFile);
                        zOut.setEncoding(this.encoding);
                        if (this.doCompress) {
                            zOut.setMethod(8);
                        } else {
                            zOut.setMethod(0);
                        }
                    }
                    this.initZipOutputStream(zOut);
                    this.addResources(this.getResourcesToAdd(zipFile), zOut);
                    if (this.doUpdate) {
                        this.addResources(this.getResourcesToUpdate(zipFile), zOut);
                    }
                    this.finalizeZipOutputStream(zOut);
                    if (this.doUpdate && !renamedFile.delete()) {
                        this.getLogger().warn("Warning: unable to delete temporary file " + renamedFile.getName());
                    }
                    success = true;
                }
                finally {
                    block30: {
                        Object var10_11 = null;
                        try {
                            if (zOut != null) {
                                zOut.close();
                            }
                        }
                        catch (IOException ex) {
                            if (!success) break block30;
                            throw ex;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                String msg = "Problem creating " + this.archiveType + ": " + ioe.getMessage();
                if (!(this.doUpdate && renamedFile == null || zipFile.delete())) {
                    msg = String.valueOf(msg) + " (and the archive is probably corrupt but I could not delete it)";
                }
                if (this.doUpdate && renamedFile != null) {
                    try {
                        FileUtils.rename((File)renamedFile, (File)zipFile);
                    }
                    catch (IOException iOException) {
                        msg = String.valueOf(msg) + " (and I couldn't rename the temporary file " + renamedFile.getName() + " back)";
                    }
                }
                throw new ArchiverException(msg, ioe);
            }
            Object var6_16 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        this.getLogger().info("Note: creating empty " + this.archiveType + " archive " + zipFile);
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(zipFile);
                byte[] empty = new byte[22];
                empty[0] = 80;
                empty[1] = 75;
                empty[2] = 5;
                empty[3] = 6;
                ((OutputStream)os).write(empty);
            }
            catch (IOException ioe) {
                throw new ArchiverException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe);
            }
            Object var4_5 = null;
            if (os == null) return true;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (os == null) throw throwable;
            try {
                ((OutputStream)os).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
    }

    public String getComment() {
        return this.comment;
    }

    public int getDirMode() {
        return this.dirMode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getFileMode() {
        return this.fileMode;
    }

    protected Map getResourcesToAdd(File file) throws IOException {
        if (!file.exists() || !this.doUpdate) {
            return this.getFiles();
        }
        ZipFile zipFile = new ZipFile(file);
        HashMap result = new HashMap();
        Iterator iter = this.getFiles().keySet().iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            if (zipFile.getEntry(fileName) != null) continue;
            result.put(fileName, this.getFiles().get(fileName));
        }
        return result;
    }

    protected Map getResourcesToUpdate(File file) throws IOException {
        HashMap result = new HashMap();
        if (file.exists() && this.doUpdate) {
            ZipFile zipFile = new ZipFile(file);
            Iterator iter = this.getFiles().keySet().iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                ZipEntry zipEntry = zipFile.getEntry(fileName);
                if (zipEntry == null) continue;
                File currentFile = (File)this.getFiles().get(fileName);
                if (zipEntry.getTime() >= currentFile.lastModified()) continue;
                result.put(fileName, this.getFiles().get(fileName));
            }
        }
        return result;
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public boolean isFilesonly() {
        return this.doFilesonly;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public boolean isRoundUp() {
        return this.roundUp;
    }

    public void reset() {
        this.setDestFile(null);
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public void setDirMode(String octalString) {
        this.dirMode = 0x4000 | Integer.parseInt(octalString, 8);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFileMode(String octalString) {
        this.fileMode = 0x8000 | Integer.parseInt(octalString, 8);
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public void setRoundUp(boolean r) {
        this.roundUp = r;
    }

    public void setUpdateMode(boolean update) {
        this.savedDoUpdate = this.doUpdate = update;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.getLogger().debug("adding directory " + vPath);
        this.addedDirs.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            if (dir != null && dir.exists()) {
                ze.setTime(dir.lastModified() + (long)(this.roundUp ? 1999 : 0));
            } else {
                ze.setTime(System.currentTimeMillis() + (long)(this.roundUp ? 1999 : 0));
            }
            ze.setSize(0L);
            ze.setMethod(0);
            ze.setCrc(EMPTY_CRC);
            ze.setUnixMode(mode);
            zOut.putNextEntry(ze);
        }
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath, int mode) throws IOException, ArchiverException {
        if (file.equals(this.getDestFile())) {
            throw new ArchiverException("A zip file cannot include itself");
        }
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified() + (long)(this.roundUp ? 1999 : 0), null, mode);
        }
        finally {
            Object var7_6 = null;
            fIn.close();
        }
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException, ArchiverException {
        if (this.entries.contains(vPath)) {
            if (this.duplicate.equals("preserve")) {
                this.getLogger().info(String.valueOf(vPath) + " already added, skipping");
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new ArchiverException("Duplicate file " + vPath + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.getLogger().debug("duplicate file " + vPath + " found, adding.");
        } else {
            this.getLogger().debug("adding entry " + vPath);
        }
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            ze.setTime(lastModified);
            ze.setMethod(this.doCompress ? 8 : 0);
            if (!zOut.isSeekable() && !this.doCompress) {
                long size = 0L;
                CRC32 cal = new CRC32();
                if (!in.markSupported()) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                        bos.write(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in = new ByteArrayInputStream(bos.toByteArray());
                } else {
                    in.mark(Integer.MAX_VALUE);
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in.reset();
                }
                ze.setSize(size);
                ze.setCrc(cal.getValue());
            }
            ze.setUnixMode(mode);
            zOut.putNextEntry(ze);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                if (count == 0) continue;
                zOut.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        }
        this.addedFiles.addElement(vPath);
    }
}

