/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.bzip2.CBZip2OutputStream;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;

public final class TarCompressionMethod
extends EnumeratedAttribute {
    private static final String NONE = "none";
    private static final String GZIP = "gzip";
    private static final String BZIP2 = "bzip2";

    public TarCompressionMethod() throws ArchiverException {
        this.setValue(NONE);
    }

    private OutputStream compress(OutputStream ostream) throws IOException {
        String value = this.getValue();
        if (GZIP.equals(value)) {
            return new GZIPOutputStream(ostream);
        }
        if (BZIP2.equals(value)) {
            ostream.write(66);
            ostream.write(90);
            return new CBZip2OutputStream(ostream);
        }
        return ostream;
    }

    public String[] getValues() {
        return new String[]{NONE, GZIP, BZIP2};
    }
}

