/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.bzip2.CBZip2OutputStream;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.tar.TarOutputStream;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;
import org.codehaus.plexus.util.StringUtils;

public class TarArchiver
extends AbstractArchiver {
    private boolean longWarningGiven = false;
    private TarLongFileMode longFileMode = new TarLongFileMode();
    private TarCompressionMethod compression = new TarCompressionMethod();
    private TarOptions options = new TarOptions();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createArchive() throws ArchiverException, IOException {
        File tarFile;
        Map listFiles = this.getFiles();
        if (listFiles == null || listFiles.size() == 0) {
            new ArchiverException("You must set at least one file.");
        }
        if ((tarFile = this.getDestFile()) == null) {
            new ArchiverException("You must set the destination tar file.");
        }
        if (tarFile.exists() && !tarFile.isFile()) {
            new ArchiverException(String.valueOf(String.valueOf(tarFile)) + " isn't a file.");
        }
        if (tarFile.exists() && !tarFile.canWrite()) {
            new ArchiverException(String.valueOf(String.valueOf(tarFile)) + " is read-only.");
        }
        Iterator iter = this.getFiles().keySet().iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            File fileToAdd = (File)this.getFiles().get(fileName);
            if (!tarFile.equals(fileToAdd)) continue;
            throw new ArchiverException("A tar file cannot include itself.");
        }
        this.getLogger().info("Building tar : " + tarFile.getAbsolutePath());
        TarOutputStream tOut = null;
        try {
            try {
                tOut = new TarOutputStream(this.compression.compress(new BufferedOutputStream(new FileOutputStream(tarFile))));
                tOut.setDebug(true);
                if (this.longFileMode.isTruncateMode()) {
                    tOut.setLongFileMode(1);
                } else if (this.longFileMode.isFailMode() || this.longFileMode.isOmitMode()) {
                    tOut.setLongFileMode(0);
                } else {
                    tOut.setLongFileMode(2);
                }
                this.longWarningGiven = false;
                Iterator iter2 = this.getFiles().keySet().iterator();
                while (iter2.hasNext()) {
                    String fileName = (String)iter2.next();
                    File f = (File)this.getFiles().get(fileName);
                    String name = StringUtils.replace((String)fileName, (char)File.separatorChar, (char)'/');
                    this.tarFile(f, tOut, fileName);
                }
            }
            catch (IOException ioe) {
                String message = "Problem creating TAR : " + ioe.getMessage();
                throw new ArchiverException(message, ioe);
            }
            Object var6_13 = null;
            if (tOut == null) return;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            if (tOut == null) throw throwable;
            try {
                tOut.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            tOut.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public TarOptions getOptions() {
        return this.options;
    }

    public void setCompression(TarCompressionMethod mode) {
        this.compression = mode;
    }

    public void setLongfile(TarLongFileMode mode) {
        this.longFileMode = mode;
    }

    public void setOptions(TarOptions options) {
        this.options = options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tarFile(File file, TarOutputStream tOut, String vPath) throws ArchiverException, IOException {
        FileInputStream fIn;
        block17: {
            block16: {
                fIn = null;
                if (vPath.length() <= 0) {
                    return;
                }
                if (file.isDirectory() && !vPath.endsWith("/")) {
                    vPath = String.valueOf(vPath) + "/";
                }
                if (vPath.startsWith("/") && !this.options.getPreserveLeadingSlashes()) {
                    int l = vPath.length();
                    if (l <= 1) {
                        return;
                    }
                    vPath = vPath.substring(1, l);
                }
                try {
                    if (vPath.length() >= 100) {
                        if (this.longFileMode.isOmitMode()) {
                            this.getLogger().info("Omitting: " + vPath);
                            Object var6_7 = null;
                            if (fIn == null) return;
                            break block16;
                        }
                        if (this.longFileMode.isWarnMode()) {
                            this.getLogger().warn("Entry: " + vPath + " longer than " + 100 + " characters.");
                            if (!this.longWarningGiven) {
                                this.getLogger().warn("Resulting tar file can only be processed successfully by GNU compatible tar commands");
                                this.longWarningGiven = true;
                            }
                        } else if (this.longFileMode.isFailMode()) {
                            throw new ArchiverException("Entry: " + vPath + " longer than " + 100 + "characters.");
                        }
                    }
                    TarEntry te = new TarEntry(vPath);
                    te.setModTime(file.lastModified());
                    if (!file.isDirectory()) {
                        te.setSize(file.length());
                        te.setMode(this.options.getMode());
                    } else {
                        te.setMode(this.options.getDirMode());
                    }
                    te.setUserName(this.options.getUserName());
                    te.setGroupName(this.options.getGroup());
                    te.setUserId(this.options.getUid());
                    te.setGroupId(this.options.getGid());
                    tOut.putNextEntry(te);
                    if (!file.isDirectory()) {
                        fIn = new FileInputStream(file);
                        byte[] buffer = new byte[8192];
                        int count = 0;
                        do {
                            tOut.write(buffer, 0, count);
                        } while ((count = fIn.read(buffer, 0, buffer.length)) != -1);
                    }
                    tOut.closeEntry();
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (fIn == null) throw throwable;
                    fIn.close();
                    throw throwable;
                }
            }
            fIn.close();
            return;
        }
        Object var6_8 = null;
        if (fIn == null) return;
        fIn.close();
    }

    public class TarOptions {
        private int fileMode = 33188;
        private int dirMode = 16877;
        private String userName = "";
        private String groupName = "";
        private int uid;
        private int gid;
        private String prefix = "";
        private boolean preserveLeadingSlashes = false;

        public int getDirMode() {
            return this.dirMode;
        }

        public int getGid() {
            return this.gid;
        }

        public String getGroup() {
            return this.groupName;
        }

        public int getMode() {
            return this.fileMode;
        }

        public boolean getPreserveLeadingSlashes() {
            return this.preserveLeadingSlashes;
        }

        public int getUid() {
            return this.uid;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setDirMode(String octalString) {
            this.dirMode = 0x4000 | Integer.parseInt(octalString, 8);
        }

        public void setGid(int gid) {
            this.gid = gid;
        }

        public void setGroup(String groupName) {
            this.groupName = groupName;
        }

        public void setMode(String octalString) {
            this.fileMode = 0x8000 | Integer.parseInt(octalString, 8);
        }

        public void setPreserveLeadingSlashes(boolean preserveLeadingSlashes) {
            this.preserveLeadingSlashes = preserveLeadingSlashes;
        }

        public void setUid(int uid) {
            this.uid = uid;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }
    }

    public static final class TarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public TarCompressionMethod() {
            try {
                this.setValue(NONE);
            }
            catch (ArchiverException archiverException) {}
        }

        private OutputStream compress(OutputStream ostream) throws IOException {
            String value = this.getValue();
            if (GZIP.equals(value)) {
                return new GZIPOutputStream(ostream);
            }
            if (BZIP2.equals(value)) {
                ostream.write(66);
                ostream.write(90);
                return new CBZip2OutputStream(ostream);
            }
            return ostream;
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }
    }
}

