/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractArchiver
extends AbstractLogEnabled
implements Archiver {
    private Logger logger;
    private String basedir;
    private String[] excludesPattern;
    private String[] includesPattern;
    private File destFile;
    private Map filesMap = new HashMap();
    private String prefix;

    public void addDirectory(File directory) throws ArchiverException {
        this.addDirectory(directory, "");
    }

    public void addDirectory(File directory, String prefix) throws ArchiverException {
        this.addDirectory(directory, prefix, null, null);
    }

    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        String pattern;
        int i;
        String[] includesPattern = null;
        String[] excludesPattern = null;
        if (includes != null) {
            includesPattern = new String[includes.length];
            i = 0;
            while (i < includes.length) {
                pattern = includes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = String.valueOf(pattern) + "**";
                }
                includesPattern[i] = pattern;
                ++i;
            }
        }
        if (excludes != null) {
            excludesPattern = new String[excludes.length];
            i = 0;
            while (i < excludes.length) {
                pattern = excludes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = String.valueOf(pattern) + "**";
                }
                excludesPattern[i] = pattern;
                ++i;
            }
        }
        DirectoryScanner scanner = new DirectoryScanner();
        if (includes != null) {
            scanner.setIncludes(includesPattern);
        }
        if (excludes != null) {
            scanner.setExcludes(excludesPattern);
        }
        if (!directory.isDirectory()) {
            throw new ArchiverException(String.valueOf(directory.getAbsolutePath()) + " isn't a directory.");
        }
        String basedir = directory.getAbsolutePath();
        scanner.setBasedir(basedir);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        int i2 = 0;
        while (i2 < files.length) {
            String file = files[i2];
            file = file.replace('\\', '/');
            if (prefix != null) {
                this.filesMap.put(String.valueOf(prefix) + file, new File(basedir, file));
            } else {
                this.filesMap.put(file, new File(basedir, file));
            }
            ++i2;
        }
    }

    public void addDirectory(File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directory, "", includes, excludes);
    }

    public void addFile(File inputFile, String destFileName) throws ArchiverException {
        if (!inputFile.isFile() || !inputFile.exists()) {
            throw new ArchiverException(String.valueOf(inputFile.getAbsolutePath()) + " isn't a file.");
        }
        destFileName = destFileName.replace('\\', '/');
        this.filesMap.put(destFileName, inputFile);
    }

    public abstract void createArchive() throws ArchiverException, IOException;

    public File getDestFile() {
        return this.destFile;
    }

    protected Map getFiles() {
        return this.filesMap;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = super.getLogger() != null ? super.getLogger() : new ConsoleLogger(1, "console");
        }
        return this.logger;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
        destFile.getParentFile().mkdirs();
    }
}

