package playfun.ads.android.sdk.component.model.networkmodel;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
public class MultipleFile implements Parcelable {
    @SerializedName("label")
    @Expose
    private String label;
    @SerializedName("name")
    @Expose
    private String name;
    @SerializedName("type")
    @Expose
    private String type;
    @SerializedName("data")
    @Expose
    private List<DataImage> dataImage = null;


    protected MultipleFile(Parcel in) {
        label = in.readString();
        name = in.readString();
        type = in.readString();
        dataImage = in.createTypedArrayList(DataImage.CREATOR);
    }

    public static final Creator<MultipleFile> CREATOR = new Creator<MultipleFile>() {
        @Override
        public MultipleFile createFromParcel(Parcel in) {
            return new MultipleFile(in);
        }

        @Override
        public MultipleFile[] newArray(int size) {
            return new MultipleFile[size];
        }
    };

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<DataImage> getDataImage() {
        return dataImage;
    }

    public void setDataImage(List<DataImage> dataImage) {
        this.dataImage = dataImage;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(label);
        parcel.writeString(name);
        parcel.writeString(type);
        parcel.writeTypedList(dataImage);
    }
}
