package playfun.ads.android.sdk.component.factory.rewards;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;

import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.popupfactory.BasePopUp;
import playfun.ads.android.sdk.component.factory.popupfactory.PopUpFactory;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.observer.AdsServices;
import playfun.ads.android.sdk.component.sate.FunAdsView;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.PopUpEnum;

public class RewardVideoPopup extends FunAdsView {
    private static final String TAG = RewardVideoPopup.class.getSimpleName();
    private FragmentTransaction fragmentTransaction;
    private BasePopUp popUp;
    private Fragment fragment;

    private Data data;

    private final Context context;

    private PopUpEnum popUpEnum;
    public RewardVideoPopup(Context context) {
        super(context);
        this.context = context;

    }

    public RewardVideoPopup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        initView();
    }

    public RewardVideoPopup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }
    public RewardVideoPopup(Context context, PopUpEnum popUpEnum, Data data) {
        super(context);
        System.out.printf(AdsUtils.TAG,"PopUpAds init : "+"PopUpAds");
        this.context = context;
        this.popUpEnum = popUpEnum;
        this.data = data;
    }

    @Override
    public void hideFunAds() {

    }

    @Override
    public void showFunAds() {
        initView();
    }

    @SuppressLint("LongLogTag")
    @Override
    public void loadFunAds(int inventoryId , String inventoryCode , int raaid) {
        Log.e(AdsUtils.TAG,"showFunAds: " + "popUpAds");
    }

    private void initView(){
        if (context == null) {
            return;
        }
        Log.i(TAG,"PopUpAds: " + "initView()");
        try {
            Activity activity = (Activity) context;
            fragmentTransaction = activity.getFragmentManager().beginTransaction();
            fragment = activity.getFragmentManager().findFragmentByTag("dialog");
            popUp = PopUpFactory.createPopUp(popUpEnum);
        } catch (Exception e) {
            System.out.println("can not cast context to Activity");
            e.printStackTrace();
        }
        if (fragment != null && fragment.isAdded()) {
            popUp.show(fragmentTransaction,"dialog");
            return;
        }
        try {
            fragmentTransaction.addToBackStack(null);
            popUp.show(fragmentTransaction,"dialog");
        } catch (Exception e) {
            System.out.println("Popup is null");
            e.printStackTrace();
        }
    }

    @Override
    public void updateAds(Data data) {
        super.updateAds(data);
        this.data = data;
    }

    @Override
    public void sendListener(AdsFunListener listener) {
        super.sendListener(listener);
        Log.e("adsView","updateAds_popup_ads");
        AdsServices adsServices = new AdsServices(data,listener);
        adsServices.attach(popUp);
        adsServices.notifyAllObserver();
    }
}
