package playfun.ads.android.sdk.component.factory.nativeads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.util.Util;
import com.google.gson.Gson;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;

public class NativeAdsFeedVideo extends RelativeLayout implements Player.EventListener{
    RequestAdsFun requestAdsFun;
    String code , packageName , versionName;
    int versionCode;
    private ImageView img_logo_video;
    private TextView text_title_video , text_description_video , text_install_video;
    private Button btn_playnow_video;
    private PlayerView video_view_video;
    private LinearLayout view_title_video, layout_install_video;
    private MediaSource mediaSource;
    public PlayerView playerView;
    public SimpleExoPlayer player;
    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();

    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Util.SDK_INT <= 23) {
            if (playerView != null) {
                playerView.onPause();
            }
            releasePlayer();
        }
    }
    private void releasePlayer() {
        if (player != null) {
            player.release();
            player = null;
        }
    }

    public NativeAdsFeedVideo(Context context) {
        this(context, null);
    }

    public NativeAdsFeedVideo(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdsFeedVideo(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from(context).inflate(R.layout.native_ads_feed_video, this);
        img_logo_video = findViewById(R.id.img_logo_video);
        video_view_video = findViewById(R.id.video_view_video);
        text_title_video = findViewById(R.id.text_title_video);
        text_description_video = findViewById(R.id.text_description_video);
        text_install_video = findViewById(R.id.text_install_video);
        view_title_video = findViewById(R.id.view_title_video);
        layout_install_video = findViewById(R.id.layout_install_video);
        btn_playnow_video = findViewById(R.id.btn_playnow_video);
        requestNativeAds(context , attrs);
    }

    private void requestNativeAds(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NativeAdsFeeds, 0, 0);
        code = typedArray.getString(R.styleable.NativeAdsFeeds_inventoryId);
        versionName = typedArray.getString(R.styleable.NativeAdsFeeds_versionName);
        packageName = typedArray.getString(R.styleable.NativeAdsFeeds_packagename);
        versionCode = typedArray.getInt(R.styleable.NativeAdsFeeds_versionCode , 1);
        AdsFunListener funListener = new AdsFunListener() {
            @Override
            public void reQuestAdsSuccess(Data data , int code) {
                Log.d("TAG" , "reQuestAdsSuccess");
//                requestAdsFun.showAds();
            }

            @Override
            public void requestAdsNativeSuccess(Data data) {
                Gson gson = new Gson();
                String dataStr = gson.toJson(data);
                Log.d("TAG" , "Something data : " + dataStr);
                Glide.with(context).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").apply(new RequestOptions()
                        .override((int) getResources().getDimension(R.dimen._32sdp),(int) getResources().getDimension(R.dimen._32sdp)))
                        .into(img_logo_video);
                text_title_video.setText(data.getMetaData().getLongTitle().getData());
                text_description_video.setText(data.getMetaData().getLongDescription().getData());
                OnClickListener onClickListener = new OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        Log.d("TAG" , "click to here");
                        Intent intent = new Intent(Intent.ACTION_VIEW);
                        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
                        intent.setData(Uri.parse(data.getMetaData().getCta0().getLink()));
                        context.startActivity(intent);
                    }
                };

                img_logo_video.setOnClickListener(onClickListener);

                text_title_video.setOnClickListener(onClickListener);
                text_description_video.setOnClickListener(onClickListener);
                text_install_video.setOnClickListener(onClickListener);
                view_title_video.setOnClickListener(onClickListener);
                layout_install_video.setOnClickListener(onClickListener);
                btn_playnow_video.setOnClickListener(onClickListener);
                if (Util.SDK_INT > 23) {
                    initializePlayer(context);
                    if (playerView != null) {
                        playerView.onResume();
                    }
                }
            }

            @Override
            public void isShowAds(boolean isShow) {
                Log.d("TAG" , "isShowAds");
            }

            @Override
            public void isCloseAds(boolean isClose) {
                Log.d("TAG" , "isCloseAds");
            }

            @Override
            public void isLoadAdsError() {
                Log.d("TAG" , "isLoadAdsError");
            }
        };
        requestAdsFun = new RequestAdsFun.RequestAdsBuilder()
                .adsCode(code)
                .of(context)
                .addListener(funListener)
                .adsUserIdForApp("userId")
                .addPakageName(packageName)
                .addVersionCode(versionCode)
                .addVersionName(versionName)
                .build();

        requestAdsFun.requestAds();
    }

    private synchronized void initializePlayer(Context context) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                mediaSource = buildMediaSource();
                try {
                    if (mediaSource != null) {
                        if (player == null) {
                            initPlayer(context);
                        }
                        player.prepare(mediaSource);
                        player.setPlayWhenReady(true);
                    }
                    com.google.android.exoplayer2.util.Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initializePlayer" + mediaSource.toString());
                } catch (Exception e) {
                    System.out.println("player is null");
                }
            }
        }).start();
    }
    @SuppressLint("NewApi")
    private void initPlayer(Context context) {
        if (context == null) {
            return;
        }

        try {
            if (player == null) {
                player = ExoPlayerFactory.newSimpleInstance(context);
                playerView.setPlayer(player);
                player.addListener(this);
            }
        } catch (Exception e) {
            System.out.println("can not initalize, Player view is null");
        }

        com.google.android.exoplayer2.util.Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initPlayer");
    }

    private MediaSource buildMediaSource() {
        MediaSource videoSource = null;
        try {
            videoSource = MediaSourseInstance.getInstance().getVideoSource();
        } catch (Exception e) {
            System.out.println("Media sourse is null");
        }
        return videoSource;
    }

}
