package playfun.ads.android.sdk.component.factory.nativeads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.util.Util;
import com.google.gson.Gson;

import de.hdodenhof.circleimageview.CircleImageView;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;
import playfun.ads.android.sdk.component.util.ScreenUtil;

public class NativeAdsFeeds extends RelativeLayout implements Player.EventListener{
    RequestAdsFun requestAdsFun;
    String code , packageName , versionName;
    int idInventory;
    int versionCode;
    private final CircleImageView img_logo;
    private final ImageView image_content;
    private final ImageView image_thump_loading;
    private final TextView text_title;
    private final TextView text_description;
    private final TextView text_install;
    private final LinearLayout view_title;
    private final LinearLayout layout_install;
    private final Button btn_playnow;
    private MediaSource mediaSource;
    public PlayerView playerView;
    public SimpleExoPlayer player;
    private final RelativeLayout nativeFeedLayout;


    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();

    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Util.SDK_INT <= 23) {
            if (playerView != null) {
                playerView.onPause();
            }
            releasePlayer();
        }
    }
    private void releasePlayer() {
        if (player != null) {
            player.release();
            player = null;
        }
    }

    public NativeAdsFeeds(Context context) {
        this(context, null);
    }

    public NativeAdsFeeds(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdsFeeds(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from(context).inflate(R.layout.native_ads_feed, this);
        nativeFeedLayout = findViewById(R.id.layout_native_feed);
        img_logo = findViewById(R.id.img_logo);
        image_content = findViewById(R.id.image_content);
        image_thump_loading = findViewById(R.id.image_thump_loading);
        text_title = findViewById(R.id.text_title);
        text_description = findViewById(R.id.text_description);
        text_install = findViewById(R.id.text_install);
        view_title = findViewById(R.id.view_title);
        layout_install = findViewById(R.id.layout_install);
        btn_playnow = findViewById(R.id.btn_playnow);
        playerView = findViewById(R.id.video_view_video);
        playerView.setShutterBackgroundColor(Color.TRANSPARENT);

        requestNativeAds(context , attrs);
        Log.d("TAG " , "Something : " + code);
    }

    private void requestNativeAds(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NativeAdsFeeds, 0, 0);
        code = typedArray.getString(R.styleable.NativeAdsFeeds_inventoryId);
        versionName = typedArray.getString(R.styleable.NativeAdsFeeds_versionName);
        packageName = typedArray.getString(R.styleable.NativeAdsFeeds_packagename);
        versionCode = typedArray.getInt(R.styleable.NativeAdsFeeds_versionCode , 1);

        AdsFunListener funListener = new AdsFunListener() {
            @Override
            public void reQuestAdsSuccess(Data data , int code) {
                Log.d("TAG" , "reQuestAdsSuccess");
//                requestAdsFun.showAds();
            }

            @Override
            public void requestAdsNativeSuccess(Data data) {
                try {
                    if(data.getMetaData() != null){
                        nativeFeedLayout.setVisibility(VISIBLE);
                        Gson gson = new Gson();
                        String dataStr = gson.toJson(data);
                        Log.d("TAG" , "Something data : " + dataStr);
                        Glide.with(context).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").apply(new RequestOptions()
                                .override((int) getResources().getDimension(R.dimen._32sdp),(int) getResources().getDimension(R.dimen._32sdp)))
                                .into(img_logo);
                        text_title.setText(data.getMetaData().getLongTitle().getData());
                        text_description.setText(data.getMetaData().getLongDescription().getData());
                        if(data.getMetaData().getImageBanner() != null)
                            Glide.with(context).asBitmap().load(data.getMetaData().getImageBanner().getData() != null ? data.getMetaData().getImageBanner().getData() : "")
                                    .into(image_content);
                        OnClickListener onClickListener = new OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                Log.d("TAG" , "click to here");
                                Intent intent = new Intent(Intent.ACTION_VIEW);
                                intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
                                intent.setData(Uri.parse(data.getMetaData().getCta0().getLink()));
                                context.startActivity(intent);
                            }
                        };

                        if(data.getMetaData().getImageBanner() != null){
                            image_content.setOnClickListener(onClickListener);
                            image_content.setVisibility(VISIBLE);
                            image_thump_loading.setVisibility(GONE);
                            playerView.setVisibility(GONE);
                        }

                        if(data.getMetaData().getVideo() != null){
                            image_content.setVisibility(GONE);
                            image_thump_loading.setVisibility(VISIBLE);
                            playerView.setVisibility(VISIBLE);
                        }
                        img_logo.setOnClickListener(onClickListener);
                        text_title.setOnClickListener(onClickListener);
                        text_description.setOnClickListener(onClickListener);
                        text_install.setOnClickListener(onClickListener);
                        view_title.setOnClickListener(onClickListener);
                        layout_install.setOnClickListener(onClickListener);
                        btn_playnow.setOnClickListener(onClickListener);

                        if(data.getMetaData().getVideo() != null){
                            if(data.getMetaData().getVideo().getData() != null)
                                MediaSourseInstance.getInstance().buildMediaSource(context.getApplicationContext(), data.getMetaData().getVideo().getData().replace(" ", "%20"));
                            if (Util.SDK_INT > 23) {
                                Activity activity = (Activity) context;
                                initializePlayer(activity);
                                if (playerView != null) {
                                    playerView.onResume();
                                }
                            }
                        }

                    }else{
                        nativeFeedLayout.setVisibility(GONE);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void isShowAds(boolean isShow) {
                Log.d("TAG" , "isShowAds");
            }

            @Override
            public void isCloseAds(boolean isClose) {
                Log.d("TAG" , "isCloseAds");
            }

            @Override
            public void isLoadAdsError() {
                Log.d("TAG" , "isLoadAdsError");
                nativeFeedLayout.setVisibility(GONE);
            }
        };
        requestAdsFun = new RequestAdsFun.RequestAdsBuilder()
                .adsCode(code)
                .of(context)
                .addListener(funListener)
                .adsUserId("userId")
                .addPakageName(packageName)
                .addVersionCode(versionCode)
                .addVersionName(versionName)
                .build();

        requestAdsFun.requestAds();
    }

    private synchronized void initializePlayer(Activity context) {
        new Handler().post(new Runnable() {
            @Override
            public void run() {
                mediaSource = buildMediaSource();
                try {
                    if (mediaSource != null) {
                        if (player == null) {
                            initPlayer(context);
                        }
                        player.prepare(mediaSource);
                        player.setPlayWhenReady(true);
                    }
                    com.google.android.exoplayer2.util.Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initializePlayer " + mediaSource.toString());
                } catch (Exception e) {
                    System.out.println("player is null");
                }
            }
        });
    }
    @SuppressLint("NewApi")
    private void initPlayer(Activity context) {
        if (context == null) {
            return;
        }
        try {
            if (player == null) {
                player = ExoPlayerFactory.newSimpleInstance(context);
                playerView.setPlayer(player);
                player.addListener(this);
            }
        } catch (Exception e) {
            System.out.println("can not initalize, Player view is null");
        }

        com.google.android.exoplayer2.util.Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initPlayer");
    }

    private MediaSource buildMediaSource() {
        MediaSource videoSource = null;
        try {
            videoSource = MediaSourseInstance.getInstance().getVideoSource();
        } catch (Exception e) {
            System.out.println("Media sourse is null");
        }
        return videoSource;
    }

    @Override
    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        com.google.android.exoplayer2.util.Log.d("Exodebug","onPlayerStateChanged" + playWhenReady + "/" + playbackState);

        switch (playbackState) {
            case Player.STATE_READY:
                image_thump_loading.setVisibility(GONE);
            case Player.STATE_BUFFERING:
                break;
            case Player.STATE_ENDED:
                initFrameFinishVideo();
                break;
            default:
                break;
        }
    }
    private void initFrameFinishVideo() {
        try {
            player.seekTo(player.getDuration()-4000);
            playerView.onPause();
            player.setPlayWhenReady(false);

        } catch (Exception e) {
            System.out.println("Player is null");
        }

    }
//    @Override
//    public void onLoadingChanged(boolean isLoading) {
//        if (isLoading) {
//            nativeFeedLayout.postDelayed(new Runnable() {
//                @Override
//                public void run() {
//                    nativeFeedLayout.setVisibility(View.VISIBLE);
//                }
//            },400);
//        }
//    }

}
