package playfun.ads.android.sdk.component.util;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;

public class ScreenUtil {
    public static boolean isLandScape(Context context) {
        int orientation;
        boolean isLandScape = false;
        if (context != null) {
            orientation = context.getResources().getConfiguration().orientation;
            if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
                // In landscape
                isLandScape = true;
            } else {
                isLandScape = false;
                // In portrait
            }
        }
        return isLandScape;
    }


    @SuppressLint("LongLogTag")
    public static int getWidthDevices(Context context) {
        DisplayMetrics displayMetrics = null;
        if (context != null) {
            displayMetrics = new DisplayMetrics();
            WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            wm.getDefaultDisplay().getMetrics(displayMetrics);
        }
        return displayMetrics.widthPixels;
    }

    public static int getHeigtDevices(Context context) {
        DisplayMetrics displayMetrics = null;
        if (context != null) {
            displayMetrics = new DisplayMetrics();
            WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            wm.getDefaultDisplay().getMetrics(displayMetrics);
        }
        return displayMetrics.heightPixels;
    }
}
