package playfun.ads.android.sdk.component.factory.popupfactory;
import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.CountDownTimer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.blur.BlurLayout;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.ImageHelper;
import playfun.ads.android.sdk.component.util.ScreenUtil;

public class PopUpAdsDialog extends BasePopUp {

    private ImageView mLagreImageView,mSmallImage;

    private Button mClose;

    private RelativeLayout mDownload;
    private RelativeLayout rlt_down;
    private BlurLayout rlt_down_land;
    private FrameLayout view_countdown_off;
    private TextView txt_countdown_off;

    private String mAction;

    private TextView mTitle, mContent, mTvDownLoad;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @SuppressLint("LongLogTag")
    @Override
    public View onCreateView( LayoutInflater inflater,  ViewGroup container,  Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.popup_portrait_withbutton,container,true);
        initView(view);
        Log.i(AdsUtils.TAG,"PopUpAdsDialog: " + "onCreateView");
        return view;
    }

    @SuppressLint("LongLogTag")
    private void initView(View view) {
        mClose = view.findViewById(R.id.btn_close_popup);
        view_countdown_off = view.findViewById(R.id.view_countdown_off);
        txt_countdown_off = view.findViewById(R.id.txt_countdown_off);
        mContent = view.findViewById(R.id.tv_content);
        mTitle = view.findViewById(R.id.tv_title);
        mLagreImageView = view.findViewById(R.id.image_main_content);
        mSmallImage = view.findViewById(R.id.image_small_content);
        mDownload = view.findViewById(R.id.btn_download);
        mTvDownLoad = view.findViewById(R.id.tv_download);
        if(!ScreenUtil.isLandScape(getActivity())){
            rlt_down = (RelativeLayout) view.findViewById(R.id.rlt_down);
            rlt_down.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    handleClick();
                }
            });
        }else{
            rlt_down_land = (BlurLayout) view.findViewById(R.id.rlt_down_land);
            rlt_down_land.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    handleClick();
                }
            });
        }
        try {
            if(data.getCountdownOff() != null){
                view_countdown_off.setVisibility(View.VISIBLE);
                mClose.setVisibility(View.GONE);
                new CountDownTimer(data.getCountdownOff().getValue() * 1000 , 1000){

                    @Override
                    public void onTick(long l) {
                        txt_countdown_off.setText("" + l/1000);
                    }

                    @Override
                    public void onFinish() {
                        view_countdown_off.setVisibility(View.GONE);
                        if(data.getCountdownOff().getDoShowClose()){
                            mClose.setVisibility(View.VISIBLE);
                        }else{
                            dismiss();
                        }
                    }
                }.start();
            }
            if(data.getMetaData().getCta0() != null && data.getMetaData().getCta0().getLink() != null) {
                mTvDownLoad.setText(data.getMetaData().getCta0().getLabel());
                mAction = data.getMetaData().getCta0().getLink();
            }

            Typeface typeface = Typeface.createFromAsset(
                    getActivity().getAssets(),
                    "sftnormal.ttf");
            int textSize = (int) getResources().getDimension(R.dimen._11sdp);
            int marginRigth = (int) getResources().getDimension(R.dimen._7sdp);
            int marginTop = (int) getResources().getDimension(R.dimen._2sdp);
            int corner = (int) getResources().getDimension(R.dimen._4sdp);
            int marginLeft = (int) getResources().getDimension(R.dimen._4sdp);
            SpannableStringBuilder builder = AdsUtils.setTexSpanBoder(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "","Free",textSize,typeface,marginRigth,marginLeft,marginTop,corner);
            mTitle.setText(builder);
            Glide.with(getActivity()).asBitmap().load(data.getMetaData().getImageBanner().getData() != null ? data.getMetaData().getImageBanner().getData() : "").apply(new RequestOptions()
                    .override((int) getResources().getDimension(R.dimen._351sdp),(int) getResources().getDimension(R.dimen._177sdp)))
                    .into(mLagreImageView);
             Glide.with(getActivity()).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").into(new SimpleTarget<Bitmap>() {
                    @Override
                    public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                        if (ScreenUtil.isLandScape(getActivity())) {
                            mTitle.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
                            mSmallImage.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,20)));
                        } else {
                            mSmallImage.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,20)));
                        }

                    }
                });
            mContent.setText(data.getMetaData().getShortDescription().getData() != null ? data.getMetaData().getShortDescription().getData() : "");
        } catch (Exception e) {
            System.out.println("Action is null");
        }

        mClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                System.out.println("Close_PopUp" + "Close");
                dismiss();
            }
        });

        mContent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                handleClick();
            }
        });
        mTitle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                handleClick();
            }
        });
        mLagreImageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                handleClick();
            }
        });
        mSmallImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                handleClick();
            }
        });
        mDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                handleClick();
            }
        });

        Log.i(AdsUtils.TAG,"PopUpAdsDialog: " + "initView");
    }

    private void handleClick(){
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.setData(Uri.parse(mAction));
            startActivity(intent);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onStop() {
        super.onStop();
    }
}
