/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory.bannerfactory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.bannerfactory.Banner;
import playfun.ads.android.sdk.component.model.networkmodel.Cta0;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.util.ImageHelper;

public class BannerAdsBlur
extends Banner {
    private final Context context;
    private View view;
    private ViewGroup viewGroup;
    private Cta0 action;
    private Button btn_close;
    private AppCompatActivity activity;
    private TextView tv_content;
    private TextView tv_titile;
    private Button btnDownload;
    private ImageView banner_image;
    private Data data;
    private static BannerAdsBlur INSTANCE;
    public static boolean isShow;
    private static AdsFunListener listener;

    @SuppressLint(value={"LongLogTag"})
    public BannerAdsBlur(Context context) {
        super(context);
        Log.i((String)"playfun.ads.android.sdk.component", (String)"BannerAds");
        this.context = context;
        INSTANCE = this;
    }

    public static BannerAdsBlur getBannerInstacne() {
        try {
            return INSTANCE;
        }
        catch (Exception e) {
            System.out.println("banner is null");
            return INSTANCE;
        }
    }

    @SuppressLint(value={"LongLogTag"})
    public void addViewIntoRoot() {
        RelativeLayout.LayoutParams lay = new RelativeLayout.LayoutParams(-1, -2);
        lay.bottomMargin = (int)this.getResources().getDimension(R.dimen._23sdp);
        lay.addRule(12);
        this.viewGroup.addView(this.view, (ViewGroup.LayoutParams)lay);
        isShow = true;
        if (listener != null) {
            listener.isShowAds(true);
            Repo.getRePo().trackingView();
        }
        Log.i((String)"playfun.ads.android.sdk.component", (String)("BannerAdsaddViewIntoRoot" + isShow));
    }

    public BannerAdsBlur(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initView();
    }

    public BannerAdsBlur(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initView();
    }

    @SuppressLint(value={"LongLogTag"})
    private void initView() {
        this.view = LayoutInflater.from((Context)this.context).inflate(R.layout.banner, (ViewGroup)this, true);
        this.banner_image = (ImageView)this.view.findViewById(R.id.banner_imageView);
        this.btn_close = (Button)this.view.findViewById(R.id.btn_close);
        this.tv_content = (TextView)this.view.findViewById(R.id.banner_tv_content);
        this.tv_titile = (TextView)this.view.findViewById(R.id.banner_tv_title);
        this.btnDownload = (Button)this.view.findViewById(R.id.btn_download_now);
        try {
            this.activity = (AppCompatActivity)this.context;
            this.viewGroup = (ViewGroup)this.activity.findViewById(0x1020002);
        }
        catch (Exception e) {
            System.out.println("ViewGroup banner is null");
        }
        this.btn_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BannerAdsBlur.this.hideFunAds();
            }
        });
        this.banner_image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BannerAdsBlur.this.handleClick();
            }
        });
        this.tv_content.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BannerAdsBlur.this.handleClick();
            }
        });
        this.tv_titile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BannerAdsBlur.this.handleClick();
            }
        });
        this.btnDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BannerAdsBlur.this.handleClick();
            }
        });
        Log.d((String)"adsView", (String)"initView banner");
        Log.i((String)"playfun.ads.android.sdk.component", (String)"BannerAdsinitView");
    }

    private void handleClick() {
        try {
            if (this.data.getMetaData().getCta0().getLink() != null) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)(this.data.getMetaData().getCta0().getLink() != null ? this.data.getMetaData().getCta0().getLink() : "")));
                this.context.startActivity(intent);
            }
        }
        catch (Exception e) {
            System.out.println("Action banner is null");
        }
    }

    @Override
    public void hideFunAds() {
        if (this.view.getParent() != null) {
            this.viewGroup.removeView(this.view);
            Log.d((String)"adsView", (String)"hideFunAdsbannerAds");
            if (listener != null) {
                isShow = false;
                listener.isCloseAds(true);
            }
        }
    }

    @Override
    public void showFunAds() {
        this.initView();
        Log.d((String)"adsView", (String)("showFunAds" + this.view.getRootView()));
    }

    @Override
    public void loadFunAds(int inventoryId, String inventoryCode, int raaid) {
        Log.d((String)"adsView", (String)"loadFunAdsbannerAds");
        Repo.getRePo().trackingView(inventoryId, inventoryCode, raaid);
    }

    public void drawAds() {
        try {
            Glide.with((Context)this.getContext()).asBitmap().load(this.data.getMetaData().getLogoImage().getData() != null ? this.data.getMetaData().getLogoImage().getData() : "").apply(new RequestOptions().override((int)this.getResources().getDimension(R.dimen._34sdp), (int)this.getResources().getDimension(R.dimen._34sdp))).into((Target)new SimpleTarget<Bitmap>(){

                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    BannerAdsBlur.this.banner_image.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource, 28)));
                }
            });
            this.tv_content.setText((CharSequence)(this.data.getMetaData().getShortDescription().getData() != null ? this.data.getMetaData().getShortDescription().getData() : ""));
            this.tv_titile.setText((CharSequence)(this.data.getMetaData().getShortTitle().getData() != null ? this.data.getMetaData().getShortTitle().getData() : ""));
            this.btnDownload.setText((CharSequence)(this.action.getLabel() != null ? this.action.getLabel() : ""));
            Log.d((String)"adsView", (String)"drawAdsbannerAds");
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateAds(Data data) {
        Log.d((String)"adsView", (String)"updateAds_banner");
        try {
            this.data = data;
            if (data.getMetaData().getCta0() != null) {
                this.action = data.getMetaData().getCta0();
            }
            this.drawAds();
        }
        catch (Exception e) {
            System.out.println("Data banner is null");
        }
    }

    @Override
    public void sendListener(AdsFunListener listener) {
        super.sendListener(listener);
        Log.d((String)"adsView", (String)"sendListener banner");
        if (this.view.getParent() == null) {
            this.addViewIntoRoot();
        }
        try {
            BannerAdsBlur.listener = listener;
        }
        catch (Exception e) {
            System.out.println("Listener banner is null");
        }
    }
}

