/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CountDownTimer;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.callback.FundAdsRequestCallBackImpl;
import playfun.ads.android.sdk.component.factory.AdsFunFactory;
import playfun.ads.android.sdk.component.factory.AttachViewService;
import playfun.ads.android.sdk.component.factory.bannerfactory.BannerAdsBlur;
import playfun.ads.android.sdk.component.factory.bannerfactory.BannerAdsWhite;
import playfun.ads.android.sdk.component.model.networkmodel.AdsFunModel;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.observer.AdsServices;
import playfun.ads.android.sdk.component.sate.FunAdsView;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;
import playfun.ads.android.sdk.component.util.PopUpType;
import playfun.ads.android.sdk.component.util.ScreenUtil;
import playfun.ads.android.sdk.component.util.UserInfor;
import playfun.ads.android.sdk.component.util.Utils;
import playfun.ads.android.sdk.component.view.TimerView;
import retrofit2.Call;
import retrofit2.Response;

public class RequestAdsFun {
    private AdsFunFactory adsFunFactory;
    private View viewNotice;
    private View viewDropdown;
    private View viewDropdownText;
    private int iventoriId;
    private String iventoriCode;
    private AdsServices services;
    private Data data;
    private final AdsFunListener listener;
    private Context context;
    private String userId = "";
    private String package_name = "";
    private String version_name = "";
    private int version_code = 0;
    private String advertisingId = "";
    private String isVip = "";
    TextView textCountdownDropdown;

    public RequestAdsFun(String adsKey, int iventoriId, String inventoryCode, Context context, AdsFunListener listener, String userId, String package_name, String version_name, int version_code, String advertisingId, String isVip) {
        this.iventoriId = iventoriId;
        this.iventoriCode = inventoryCode;
        this.context = context;
        this.listener = listener;
        this.userId = userId;
        this.package_name = package_name;
        this.version_name = version_name;
        this.version_code = version_code;
        this.advertisingId = advertisingId;
        this.isVip = isVip;
        UserInfor userInfor = UserInfor.getInstance();
        userInfor.setPackage_name(this.package_name);
        userInfor.setIsVip(this.isVip);
        userInfor.setUserId(this.userId);
        userInfor.setVersion_name(this.version_name);
        userInfor.setVersion_code(String.valueOf(this.version_code));
        userInfor.setDevice_resolution("w:" + ScreenUtil.getWidthDevices(context) + "\th:" + ScreenUtil.getHeigtDevices(context));
        userInfor.setPackage_name(context.getPackageName());
        userInfor.setAdvertisingId(this.advertisingId);
        if (ScreenUtil.isLandScape(context)) {
            userInfor.setOrientation("landScape");
            return;
        }
        userInfor.setOrientation("portrait");
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public int getIventoriId() {
        return this.iventoriId;
    }

    public void setIventoriId(int iventoriId) {
        this.iventoriId = iventoriId;
    }

    public String getIventoriCode() {
        return this.iventoriCode;
    }

    public void setIventoriCode(String iventoriCode) {
        this.iventoriCode = iventoriCode;
    }

    public void showAdsAfterCountdown(final int countdown) {
        final AppCompatActivity activity = (AppCompatActivity)this.context;
        if (countdown >= 0) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    final ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                    LayoutInflater inflater = LayoutInflater.from((Context)activity);
                    if (RequestAdsFun.this.viewNotice == null) {
                        RequestAdsFun.this.viewNotice = inflater.inflate(R.layout.count_down_view, null);
                    }
                    final TextView textCountdown = (TextView)RequestAdsFun.this.viewNotice.findViewById(R.id.text_count_down);
                    rootView.addView(RequestAdsFun.this.viewNotice);
                    new CountDownTimer(countdown * 1000, 1000L){

                        public void onTick(long l) {
                            textCountdown.setText((CharSequence)(" " + l / 1000L + "s"));
                        }

                        public void onFinish() {
                            rootView.removeView(RequestAdsFun.this.viewNotice);
                            RequestAdsFun.this.showAds();
                        }
                    }.start();
                }
            });
        }
    }

    public void showAdsDropdown(final Data data, final AttachViewService attachViewService, final String inventoryCode, final int inventoryId) {
        final AppCompatActivity activity = (AppCompatActivity)this.context;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                    LayoutInflater inflater = LayoutInflater.from((Context)activity);
                    if (RequestAdsFun.this.viewDropdown != null) {
                        return;
                    }
                    RequestAdsFun.this.viewDropdown = inflater.inflate(R.layout.drop_down_view, null);
                    FrameLayout layout_content_dropdown = (FrameLayout)RequestAdsFun.this.viewDropdown.findViewById(R.id.layout_content_dropdown);
                    ImageView banner_imageView_dropdown = (ImageView)RequestAdsFun.this.viewDropdown.findViewById(R.id.banner_imageView_dropdown);
                    TextView banner_tv_title_dropdown = (TextView)RequestAdsFun.this.viewDropdown.findViewById(R.id.banner_tv_title_dropdown);
                    TextView banner_tv_content_dropdown = (TextView)RequestAdsFun.this.viewDropdown.findViewById(R.id.banner_tv_content_dropdown);
                    Button btn_download_now_dropdown = (Button)RequestAdsFun.this.viewDropdown.findViewById(R.id.btn_download_now_dropdown);
                    banner_tv_title_dropdown.setText((CharSequence)(data.getMetaData().getShortTitle() != null ? data.getMetaData().getShortTitle().getData() : ""));
                    banner_tv_content_dropdown.setText((CharSequence)(data.getMetaData().getShortDescription() != null ? data.getMetaData().getShortDescription().getData() : ""));
                    Glide.with((FragmentActivity)activity).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").into(banner_imageView_dropdown);
                    if (ScreenUtil.isLandScape((Context)activity)) {
                        RequestAdsFun.this.textCountdownDropdown = (TextView)RequestAdsFun.this.viewDropdown.findViewById(R.id.text_countdown_dropdown);
                        TimerView crpv = (TimerView)RequestAdsFun.this.viewDropdown.findViewById(R.id.crpv);
                        crpv.start(data.getCountdownOff().getValue());
                    }
                    btn_download_now_dropdown.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Utils.handleClick(activity, data.getMetaData().getCta0().getLink());
                        }
                    });
                    banner_tv_title_dropdown.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Utils.handleClick(activity, data.getMetaData().getCta0().getLink());
                        }
                    });
                    banner_tv_content_dropdown.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Utils.handleClick(activity, data.getMetaData().getCta0().getLink());
                        }
                    });
                    banner_imageView_dropdown.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Utils.handleClick(activity, data.getMetaData().getCta0().getLink());
                        }
                    });
                    layout_content_dropdown.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Utils.handleClick(activity, data.getMetaData().getCta0().getLink());
                        }
                    });
                    if (rootView.indexOfChild(RequestAdsFun.this.viewDropdown) == -1) {
                        Log.d((String)"TAG", (String)"GO TO HERE");
                    }
                    rootView.addView(RequestAdsFun.this.viewDropdown);
                    attachViewService.adShowing();
                    RequestAdsFun.this.viewDropdown.startAnimation(AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_in));
                    new CountDownTimer(data.getCountdownOff().getValue() * 1000, 1000L){

                        public void onTick(long l) {
                            if (ScreenUtil.isLandScape((Context)activity)) {
                                RequestAdsFun.this.textCountdownDropdown.setText((CharSequence)(" " + l / 1000L));
                            }
                        }

                        public void onFinish() {
                            Animation animation = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_out);
                            animation.setAnimationListener(new Animation.AnimationListener(){

                                public void onAnimationStart(Animation animation) {
                                }

                                public void onAnimationRepeat(Animation animation) {
                                }

                                public void onAnimationEnd(Animation animation) {
                                    ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                                    rootView.removeView(RequestAdsFun.this.viewDropdown);
                                    attachViewService.closeAds();
                                }
                            });
                            RequestAdsFun.this.viewDropdown.startAnimation(animation);
                        }
                    }.start();
                    Repo.getRePo().trackingView(inventoryId, inventoryCode, data.getRaaId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showAdsDropdownText(final Data data, final AttachViewService attachViewService, final String inventoryCode, final int inventoryId) {
        final AppCompatActivity activity = (AppCompatActivity)this.context;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                    LayoutInflater inflater = LayoutInflater.from((Context)activity);
                    if (RequestAdsFun.this.viewDropdownText == null) {
                        RequestAdsFun.this.viewDropdownText = inflater.inflate(R.layout.drop_down_view_text, null);
                    }
                    FrameLayout layout_content_dropdown = (FrameLayout)RequestAdsFun.this.viewDropdownText.findViewById(R.id.layout_content_dropdown);
                    TextView dropdown_content_text = (TextView)RequestAdsFun.this.viewDropdownText.findViewById(R.id.dropdown_content_text);
                    dropdown_content_text.setText((CharSequence)(data.getMetaData().getLongTitle() != null ? data.getMetaData().getLongTitle().getData() : ""));
                    dropdown_content_text.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Utils.handleClick(activity, data.getMetaData().getCta0().getLink());
                        }
                    });
                    layout_content_dropdown.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Utils.handleClick(activity, data.getMetaData().getCta0().getLink());
                        }
                    });
                    rootView.addView(RequestAdsFun.this.viewDropdownText);
                    attachViewService.adShowing();
                    RequestAdsFun.this.viewDropdownText.startAnimation(AnimationUtils.loadAnimation((Context)activity, (int)R.anim.fade_in));
                    new CountDownTimer(data.getCountdownOff().getValue() * 1000, 1000L){

                        public void onTick(long l) {
                        }

                        public void onFinish() {
                            Animation animation = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.fade_out);
                            animation.setAnimationListener(new Animation.AnimationListener(){

                                public void onAnimationStart(Animation animation) {
                                }

                                public void onAnimationRepeat(Animation animation) {
                                }

                                public void onAnimationEnd(Animation animation) {
                                    ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                                    rootView.removeView(RequestAdsFun.this.viewDropdownText);
                                    attachViewService.closeAds();
                                }
                            });
                            RequestAdsFun.this.viewDropdownText.startAnimation(animation);
                        }
                    }.start();
                    Repo.getRePo().trackingView(inventoryId, inventoryCode, data.getRaaId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showAds(Data data, AttachViewService attachViewService, String inventoryCode, int inventoryId) {
        switch (data.getTemplateType()) {
            case "popup-dropdown": {
                this.showAdsDropdown(data, attachViewService, inventoryCode, inventoryId);
                break;
            }
            case "popup-dropdown-text": {
                this.showAdsDropdownText(data, attachViewService, inventoryCode, inventoryId);
                break;
            }
            default: {
                this.showAds();
            }
        }
    }

    @SuppressLint(value={"LongLogTag"})
    public synchronized void showAds() {
        String type = "";
        if (this.data == null) {
            Log.i((String)"playfun.ads.android.sdk.component", (String)"DATA IS NULL");
            return;
        }
        try {
            this.adsFunFactory = new AdsFunFactory(this.context);
            type = this.data.getTemplateType();
            Log.i((String)"playfun.ads.android.sdk.component", (String)("AdsFunFactory: " + this.adsFunFactory.toString()));
            Log.i((String)"playfun.ads.android.sdk.component", (String)("Data: " + this.data.toString()));
        }
        catch (Exception e) {
            System.out.printf("playfun.ads.android.sdk.component", "AdsFunFactory null");
            System.out.printf("playfun.ads.android.sdk.component", e.toString());
            e.printStackTrace();
        }
        try {
            this.services = new AdsServices.AdsServiceBuilder().setData(this.data).setListener(this.listener).build();
            Log.i((String)"playfun.ads.android.sdk.component", (String)("AdsServices: " + this.services.toString()));
        }
        catch (Exception e) {
            System.out.printf("playfun.ads.android.sdk.component", "AdsServices is null");
            e.printStackTrace();
        }
        if (type.equals("inline-blur")) {
            this.checkBannerBlurIshow();
        }
        if (type.equals("inline-blur")) {
            this.checkBannerWhiteIshow();
        }
        try {
            FunAdsView funAdsView = this.initPopUpSdk(type);
            funAdsView.loadFunAds(this.iventoriId, this.iventoriCode, this.data.getRaaId());
            if (funAdsView != null) {
                funAdsView.showFunAds();
                this.services.attach(funAdsView);
                this.services.notifyAllObserver();
            }
            Log.i((String)"playfun.ads.android.sdk.component", (String)funAdsView.toString());
        }
        catch (Exception e) {
            System.out.printf("playfun.ads.android.sdk.component", "FunadsView is null");
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"LongLogTag"})
    private void checkBannerWhiteIshow() {
        try {
            BannerAdsWhite bannerAdsWhite = BannerAdsWhite.getBannerInstacne();
            if (BannerAdsWhite.isShow) {
                bannerAdsWhite.hideFunAds();
            }
        }
        catch (Exception e) {
            System.out.printf("playfun.ads.android.sdk.component", "Can not hide Banner Ads");
            e.printStackTrace();
        }
        Log.i((String)"playfun.ads.android.sdk.component", (String)"BannerAds is show: checkBannerIshow");
    }

    @SuppressLint(value={"LongLogTag"})
    private void checkBannerBlurIshow() {
        try {
            BannerAdsBlur bannerAdsBlur = BannerAdsBlur.getBannerInstacne();
            if (BannerAdsBlur.isShow) {
                bannerAdsBlur.hideFunAds();
            }
        }
        catch (Exception e) {
            System.out.printf("playfun.ads.android.sdk.component", "Can not hide Banner Ads");
            e.printStackTrace();
        }
        Log.i((String)"playfun.ads.android.sdk.component", (String)"BannerAds is show: checkBannerIshow");
    }

    @SuppressLint(value={"LongLogTag"})
    private FunAdsView initPopUpSdk(String type) throws IllegalAccessException {
        Log.i((String)"playfun.ads.android.sdk.component", (String)"FunAdsView: initPopUpSdk");
        switch (type) {
            case "banner-call-action": {
                return this.adsFunFactory.createPopUp(PopUpType.POPUP);
            }
            case "videos": {
                return this.adsFunFactory.createPopUp(PopUpType.VIDEO);
            }
            case "long-images": {
                return this.adsFunFactory.createPopUp(PopUpType.LONG_IMAGE);
            }
            case "inline-blur": {
                return this.adsFunFactory.createPopUp(PopUpType.BANNER_BLUR);
            }
            case "inline-white": {
                return this.adsFunFactory.createPopUp(PopUpType.BANNER_WHITE);
            }
        }
        throw new IllegalAccessException("Not Support Ads");
    }

    public void requestAds() {
        FundAdsRequestCallBackImpl<AdsFunModel> funModelFundAdsRequestCallBack = new FundAdsRequestCallBackImpl<AdsFunModel>(){

            @Override
            public void success(Response<AdsFunModel> success) {
                try {
                    RequestAdsFun.this.data = ((AdsFunModel)success.body()).getData();
                    switch (RequestAdsFun.this.data.getTemplateType()) {
                        case "videos": {
                            if (RequestAdsFun.this.context == null) {
                                return;
                            }
                            if (RequestAdsFun.this.data.getMetaData().getVideo().getData() == null) break;
                            MediaSourseInstance.getInstance().buildMediaSource(RequestAdsFun.this.context.getApplicationContext(), RequestAdsFun.this.data.getMetaData().getVideo().getData().replace(" ", "%20"));
                            break;
                        }
                        case "feed-native": 
                        case "banner-native": 
                        case "slider-cta-native": {
                            if (RequestAdsFun.this.listener == null) break;
                            RequestAdsFun.this.listener.requestAdsNativeSuccess(RequestAdsFun.this.data);
                        }
                    }
                    if (RequestAdsFun.this.listener != null) {
                        RequestAdsFun.this.listener.reQuestAdsSuccess(RequestAdsFun.this.data, 200);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.out.println("Can not get data, Data get is null");
                    e.printStackTrace();
                }
            }

            @Override
            public void error(int error) {
                if (RequestAdsFun.this.listener != null) {
                    RequestAdsFun.this.listener.isLoadAdsError();
                }
            }

            @Override
            public void fail(Call<AdsFunModel> call) {
                if (RequestAdsFun.this.listener != null) {
                    RequestAdsFun.this.listener.isLoadAdsError();
                    System.out.printf("playfun.ads.android.sdk.component", "" + call.toString());
                }
            }
        };
        try {
            Repo.getRePo().requestAds(funModelFundAdsRequestCallBack, this.iventoriId, this.iventoriCode);
        }
        catch (Exception e) {
            System.out.println("can not call request ads");
            e.printStackTrace();
        }
    }

    public static class RequestAdsBuilder {
        private int iventoriId;
        private String iventoriCode;
        private String adsKey;
        private Context context;
        private AdsFunListener listener;
        private String userId = "";
        private String package_name = "";
        private String version_name = "";
        private int version_code = 0;
        private String advertisingId = "";
        private String isVip = "";

        public RequestAdsBuilder of(Context context) {
            this.context = context;
            return this;
        }

        public RequestAdsBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public RequestAdsBuilder adsCode(String iventoriCode) {
            this.iventoriCode = iventoriCode;
            return this;
        }

        public RequestAdsBuilder adsId(int iventoriId) {
            this.iventoriId = iventoriId;
            return this;
        }

        public RequestAdsBuilder adsKey(String adskey) {
            this.adsKey = adskey;
            return this;
        }

        public RequestAdsBuilder addListener(AdsFunListener listener) {
            try {
                this.listener = listener;
            }
            catch (Exception e) {
                System.out.println("Listener is null");
            }
            return this;
        }

        public RequestAdsBuilder adsUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public RequestAdsBuilder addPakageName(String package_name) {
            this.package_name = package_name;
            return this;
        }

        public RequestAdsBuilder isVip(String isVip) {
            this.isVip = isVip;
            return this;
        }

        public RequestAdsBuilder addVersionName(String version_name) {
            this.version_name = version_name;
            return this;
        }

        public RequestAdsBuilder addVersionCode(int version_code) {
            this.version_code = version_code;
            return this;
        }

        public RequestAdsBuilder addAdsVertisingId(String advertisingId) {
            this.advertisingId = advertisingId;
            return this;
        }

        @SuppressLint(value={"LongLogTag"})
        public RequestAdsFun build() {
            RequestAdsFun requestAdsFun = null;
            try {
                requestAdsFun = new RequestAdsFun(this.adsKey, this.iventoriId, this.iventoriCode, this.context, this.listener, this.userId, this.package_name, this.version_name, this.version_code, this.advertisingId, this.isVip);
            }
            catch (Exception e) {
                System.out.printf("playfun.ads.android.sdk.component", "Context is null");
                e.printStackTrace();
            }
            return requestAdsFun;
        }
    }
}

