package playfun.ads.android.sdk.component.factory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import android.util.TypedValue;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.List;

import playfun.ads.android.sdk.component.callback.GetListInventoryIdCallbackImpl;
import playfun.ads.android.sdk.component.callback.GetListInventoryListener;
import playfun.ads.android.sdk.component.model.networkmodel.DataInventory;
import playfun.ads.android.sdk.component.model.networkmodel.InventoryIdModel;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.Constants;
import playfun.ads.android.sdk.component.util.Preference;
import retrofit2.Call;
import retrofit2.Response;

public class RequestListInventoryId {
    private String adsKey;
    private Context context;
    private String userId;
    private String packageName;
    private String versionName;
    private String versionCode;
    private String advertisingId;
    private GetListInventoryListener listener;

    private List<DataInventory> dataInventorys;

    public RequestListInventoryId(String adsKey, Context context, GetListInventoryListener listener ,String userId,
                                  String packageName, String versionName, String versionCode, String advertisingId) {
        this.adsKey = adsKey;
        this.context = context;
        this.userId = userId;
        this.packageName = packageName;
        this.versionName = versionName;
        this.versionCode = versionCode;
        this.advertisingId = advertisingId;
        this.listener = listener;
    }

    public void getListInventoryId(){
        GetListInventoryIdCallbackImpl<InventoryIdModel> getListInventoryIdCallback = new GetListInventoryIdCallbackImpl<InventoryIdModel>() {
            @Override
            public void onSuccess(Response<InventoryIdModel> onSuccess) {
                try {
                    dataInventorys = onSuccess.body().getData();
                    if(listener != null){
                        listener.getListInventoryIdSuccess(dataInventorys);
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int errorCode, String message) {
                if (listener != null) {
                    listener.getListInventoryIdError(errorCode , message);
                }
            }

            @Override
            public void onFail(Call<InventoryIdModel> call) {
                if (listener != null) {
                    listener.getListInventoryIdFail();
                    System.out.printf(AdsUtils.TAG,"" + call.toString());
                }
            }
        };

        try {
            Repo.getRePo().getListInventoryId(getListInventoryIdCallback , adsKey);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public String getListInventoryJson(Context context){
        Log.d("Tag" , "json result" + Preference.getString(context , "LIST_INVENTORY"));
        return Preference.getString(context , "LIST_INVENTORY");
    }
    public GetListInventoryListener getListInventoryListener(){
        return listener;
    }

    public static class RequestListInventoryIdBuilder{
        private String adsKey;
        private Context context;
        private String userId;
        private String packageName;
        private String versionName;
        private String versionCode;
        private String advertisingId;
        private GetListInventoryListener listener;

        public RequestListInventoryIdBuilder() {
        }

        public RequestListInventoryIdBuilder of(Context context){
            this.context = context;
            return this;
        }

        public RequestListInventoryIdBuilder context(Context context){
            this.context = context;
            return this;
        }

        public RequestListInventoryIdBuilder addAdsKey(String adsKey){
            this.adsKey = adsKey;
            return this;
        }

        public RequestListInventoryIdBuilder addUserId(String userId){
            this.userId = userId;
            return this;
        }

        public RequestListInventoryIdBuilder addPackageName(String packageName){
            this.packageName = packageName;
            return this;
        }

        public RequestListInventoryIdBuilder addVersionName (String versionName){
            this.versionName = versionName;
            return this;
        }
        public RequestListInventoryIdBuilder addVersionCode(String versionCode){
            this.versionCode = versionCode;
            return this;
        }

        public RequestListInventoryIdBuilder addAdvertisingId(String advertisingId){
            this.advertisingId = advertisingId;
            return this;
        }
        public RequestListInventoryIdBuilder addListener(GetListInventoryListener getListInventoryListener){
            this.listener = getListInventoryListener;
            return this;
        }


        @SuppressLint("LongLogTag")
        public RequestListInventoryId build() {
            RequestListInventoryId requestListInventoryId = null;
            try {
                requestListInventoryId = new RequestListInventoryId(adsKey, context, listener, userId, packageName, versionName, versionCode, advertisingId);
            } catch (Exception e) {
                System.out.printf(AdsUtils.TAG,"Context is null");
                e.printStackTrace();
            }
            return requestListInventoryId;
        }

    }
}
