package playfun.ads.android.sdk.component.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;

import playfun.ads.android.sdk.BuildConfig;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitHelper {

    private static final String TAG = RetrofitHelper.class.getSimpleName();

    /**
     * TODO @Dương version release thì bỏ đoạn log provideOkHttpClient của OKHttp đi . Vì thằng này sẽ dump hết log của response ra .
     * @param service
     * @param <T>
     * @return
     */
    public static <T> T createServiceProduct(Class<T> service) {
        Retrofit retrofit = new Retrofit.Builder()
//                .baseUrl(Host.PRODUCT_URL)
                .baseUrl(Host.STG_URL)
//                .baseUrl(Host.DEV_URL)
                .addConverterFactory(new NullOnEmptyConverterFactory())
                .addConverterFactory(GsonConverterFactory.create(getGson()))
                .client(provideOkHttpClient())
                .build();
        return retrofit.create(service);
    }

    public static <T> T createServicePixel(Class<T> service) {
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(Host.STG_PIXEL)
                .addConverterFactory(new NullOnEmptyConverterFactory())
                .addConverterFactory(GsonConverterFactory.create(getGson()))
                .client(provideOkHttpClient())
                .build();
        return retrofit.create(service);
    }

    private static Gson getGson() {
        return new GsonBuilder()
                .setLenient()
                .create();
    }

    private static OkHttpClient provideOkHttpClient() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        if (BuildConfig.DEBUG) {
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        } else {
            logging.setLevel(HttpLoggingInterceptor.Level.NONE);
        }
        return new OkHttpClient.Builder()
                .addInterceptor(new CustomInterceptor())
                .addInterceptor(logging)
                .connectTimeout(30, TimeUnit.SECONDS)
                .readTimeout(30, TimeUnit.SECONDS)
                .writeTimeout(30, TimeUnit.SECONDS)
                .retryOnConnectionFailure(true)
                .build();
    }

    private static class NullOnEmptyConverterFactory extends Converter.Factory {
        @Override
        public Converter<ResponseBody, ?> responseBodyConverter(Type type,
                                                                Annotation[] annotations,
                                                                Retrofit retrofit) {
            final Converter<ResponseBody, ?> delegate =
                    retrofit.nextResponseBodyConverter(this, type, annotations);
            return new Converter<ResponseBody, Object>() {
                @Override
                public Object convert(ResponseBody value) throws IOException {
                    if (value.contentLength() == 0) {
                        return null;
                    }
                    return delegate.convert(value);
                }
            };
        }
    }
}