/*
 * Decompiled with CFR 0.152.
 */
package SerwerSMS;

import SerwerSMS.Account;
import SerwerSMS.Blacklist;
import SerwerSMS.Broadcaster;
import SerwerSMS.Contact;
import SerwerSMS.Fault;
import SerwerSMS.File;
import SerwerSMS.Group;
import SerwerSMS.Message;
import SerwerSMS.Payment;
import SerwerSMS.Phone;
import SerwerSMS.Premium;
import SerwerSMS.Stat;
import SerwerSMS.Subaccount;
import SerwerSMS.Template;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerwerSMS {
    private String username = "";
    private String password = "";
    private String api = "https://api2.serwersms.pl/";
    private String format = "json";
    private String client = "client_java";
    private HttpURLConnection http;
    public Message message = null;
    public File file = null;
    public Blacklist blacklist = null;
    public Fault fault = null;
    public Stat stat = null;
    public Phone phone = null;
    public Account account = null;
    public Contact contact = null;
    public Group group = null;
    public Broadcaster broadcaster = null;
    public Premium premium = null;
    public Template template = null;
    public Subaccount subaccount = null;
    public Payment payment = null;

    public SerwerSMS(String user, String pass) throws Exception {
        if (user.isEmpty() || pass.isEmpty()) {
            throw new Exception("Brak danych autoryzacyjnych");
        }
        this.username = user;
        this.password = pass;
        this.message = new Message(this);
        this.file = new File(this);
        this.blacklist = new Blacklist(this);
        this.fault = new Fault(this);
        this.stat = new Stat(this);
        this.phone = new Phone(this);
        this.account = new Account(this);
        this.contact = new Contact(this);
        this.group = new Group(this);
        this.broadcaster = new Broadcaster(this);
        this.premium = new Premium(this);
        this.template = new Template(this);
        this.subaccount = new Subaccount(this);
        this.payment = new Payment(this);
    }

    public String send(String action, HashMap<String, String> params) {
        StringBuilder response = new StringBuilder();
        try {
            params.put("username", this.username);
            params.put("password", this.password);
            params.put("system", this.client);
            this.request(action, params);
            InputStream inputStream = null;
            if (this.http != null) {
                inputStream = this.http.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                this.http.disconnect();
            }
            return response.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public byte[] sendByte(String action, HashMap<String, String> params) {
        try {
            params.put("username", this.username);
            params.put("password", this.password);
            this.request(action, params);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream inputStream = null;
            if (this.http != null) {
                int length;
                inputStream = this.http.getInputStream();
                byte[] ba1 = new byte[1024];
                while ((length = inputStream.read(ba1)) != -1) {
                    bos.write(ba1, 0, length);
                }
                this.http.disconnect();
            }
            return bos.toByteArray();
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            return bos.toByteArray();
        }
    }

    public boolean setFormat(String type) {
        if ((type = type.toLowerCase()) == "xml" || type == "json") {
            this.format = type;
            return true;
        }
        return false;
    }

    private void request(String action, HashMap<String, String> params) throws Exception {
        action = action + "." + this.format;
        String requestURL = "";
        requestURL = requestURL.concat(this.api);
        requestURL = requestURL.concat(action);
        URL url = new URL(requestURL);
        this.http = (HttpURLConnection)url.openConnection();
        this.http.setUseCaches(false);
        this.http.setDoInput(true);
        this.http.setRequestMethod("POST");
        this.http.setRequestProperty("Content-Type", "application/json");
        JSONObject jsonParam = new JSONObject();
        if (params != null && params.size() > 0) {
            this.http.setDoOutput(true);
            for (String key : params.keySet()) {
                String value = params.get(key);
                jsonParam.put(key, (Object)value);
            }
            String requestString = jsonParam.toString();
            OutputStream os = this.http.getOutputStream();
            os.write(requestString.getBytes("UTF-8"));
            os.close();
        }
    }
}

