/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.multitouch;

import android.content.Context;
import android.view.MotionEvent;

public abstract class BaseGestureDetector {
    protected final Context mContext;
    protected boolean mGestureInProgress;
    protected MotionEvent mPrevEvent;
    protected MotionEvent mCurrEvent;
    protected float mCurrPressure;
    protected float mPrevPressure;
    protected long mTimeDelta;
    protected static final float PRESSURE_THRESHOLD = 0.67f;

    public BaseGestureDetector(Context context) {
        this.mContext = context;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int actionCode = event.getAction() & 0xFF;
        if (!this.mGestureInProgress) {
            this.handleStartProgressEvent(actionCode, event);
        } else {
            this.handleInProgressEvent(actionCode, event);
        }
        return this.mGestureInProgress;
    }

    protected abstract void handleStartProgressEvent(int var1, MotionEvent var2);

    protected abstract void handleInProgressEvent(int var1, MotionEvent var2);

    protected void updateStateByEvent(MotionEvent curr) {
        MotionEvent prev = this.mPrevEvent;
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)curr);
        if (this.mPrevEvent == null) {
            this.mTimeDelta = 0L;
            this.mCurrPressure = curr.getPressure(curr.getActionIndex());
            this.mCurrPressure = this.mPrevPressure = curr.getPressure(prev.getActionIndex());
        } else {
            this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
            this.mCurrPressure = curr.getPressure(curr.getActionIndex());
            this.mPrevPressure = prev.getPressure(prev.getActionIndex());
        }
    }

    protected void resetState() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mGestureInProgress = false;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }
}

