/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.viewer;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;

public class TextureHelper {
    public static int loadTexture(Resources resources, int resourceId) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)options);
        return TextureHelper.loadTexture(bitmap);
    }

    public static int loadTexture(Resources resources, int resourceId, int handle) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)options);
        return TextureHelper.loadTexture(bitmap, handle);
    }

    public static int loadTexture(Bitmap bitmap) {
        int[] textureHandle = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandle, (int)0);
        return TextureHelper.loadTexture(bitmap, textureHandle[0]);
    }

    public static int loadTexture(Bitmap bitmap, int handle) {
        int[] textureHandle = new int[]{handle};
        if (textureHandle[0] != 0) {
            GLES20.glBindTexture((int)3553, (int)textureHandle[0]);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            bitmap.recycle();
        }
        if (textureHandle[0] == 0) {
            throw new RuntimeException("Error loading texture.");
        }
        Log.i((String)"debug", (String)"texutre loaded");
        return textureHandle[0];
    }

    public static void releaseTexture(int handle) {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{handle}, (int)0);
    }
}

