/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.viewer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import pl.rjuszczyk.panorama.R;
import pl.rjuszczyk.panorama.viewer.Mesh;
import pl.rjuszczyk.panorama.viewer.PanoramaGLSurfaceView;
import pl.rjuszczyk.panorama.viewer.PerspectiveMatrix;
import pl.rjuszczyk.panorama.viewer.RawImageDrawer;
import pl.rjuszczyk.panorama.viewer.RawResourceReader;
import pl.rjuszczyk.panorama.viewer.ShaderHelper;
import pl.rjuszczyk.panorama.viewer.TexturedMesh;

public class PanoramaRenderer
implements GLSurfaceView.Renderer {
    private final float[] mLightPosInModelSpace = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] mLightPosInWorldSpace = new float[4];
    private final float[] mLightPosInEyeSpace = new float[4];
    private final int mPositionDataSize = 3;
    private final int mNormalDataSize = 3;
    private final int mUVDataSize = 2;
    public float[] mModelMatrix = new float[16];
    public float mCameraZTarget = 1.0f;
    TexturedMesh sphereMeshWithTexture;
    float ratio;
    long mLastTime = -1L;
    boolean firstFrame = true;
    private RawImageDrawer mImageDrawer;
    private int mPerVertexProgramHandle;
    private float[] mProjectionMatrix = new float[16];
    private Resources mResources;
    private int mModelResourceId;
    private int mTextureResourceId;
    private float[] mViewMatrix = new float[16];
    private float[] mMVPMatrix = new float[16];
    private float[] mLightModelMatrix = new float[16];
    private int mMVPMatrixHandle;
    private int mMVMatrixHandle;
    private int mLightPosHandle;
    private int mPositionHandle;
    private int mColorHandle;
    private int mNormalHandle;
    private int mTextureUniformHandle;
    private int mTextureCoordinateHandle;
    private float mModelScale = 1.0f;
    private float mModelRotationX = 0.0f;
    private float mModelRotationY = 0.0f;
    private float mModelRotationZ = 0.0f;
    private float mCameraZ = 1.0f;
    private float mModelScaleTarget = 1.0f;
    private float mModelRotationXTarget = 0.0f;
    private float mModelRotationYTarget = 0.0f;
    private float mModelRotationZTarget = 0.0f;
    private float velocityX = 0.0f;
    private float velocityY = 0.0f;
    float[] mModelRotationMatrix = null;
    public float speedX = 0.0f;
    public float speedY = 0.0f;
    float fractionPerMs = 2.0f;
    Runnable runnableToDo = null;
    float[] right = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    float[] up = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
    float[] touchRotationMatrix = new float[16];

    public PanoramaRenderer(Context context, RawImageDrawer imageDrawer, int modelResourceId) {
        this.mResources = context.getResources();
        this.mImageDrawer = imageDrawer;
        this.mModelResourceId = modelResourceId;
        this.mTextureResourceId = -1;
        this.initTouchRotation();
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        GLES20.glClearColor((float)0.390625f, (float)0.7109375f, (float)0.9375f, (float)0.0f);
        GLES20.glEnable((int)2884);
        GLES20.glEnable((int)2929);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        String vertexShader = RawResourceReader.readTextFileFromRawResource(this.mResources, R.raw.walls_vertexshader);
        String fragmentShader = RawResourceReader.readTextFileFromRawResource(this.mResources, R.raw.walls_fragmentshader);
        int vertexShaderHandle = ShaderHelper.compileShader(35633, vertexShader);
        int fragmentShaderHandle = ShaderHelper.compileShader(35632, fragmentShader);
        this.mPerVertexProgramHandle = ShaderHelper.createAndLinkProgram(vertexShaderHandle, fragmentShaderHandle, new String[]{"a_Position", "a_Color", "a_Normal", "a_TexCoordinate"});
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.ratio = (float)width / (float)height;
        PerspectiveMatrix.perspectiveM(this.mProjectionMatrix, 0, 60.0f, this.ratio, 0.25f, 100.0f);
        Mesh sphereMesh = Mesh.getMeshSerialized(this.mModelResourceId, this.mResources);
        if (this.mTextureResourceId == -1) {
            this.sphereMeshWithTexture = new TexturedMesh(sphereMesh, -1);
        } else {
            int currentTextureHanlde = this.mImageDrawer.getTextureHandlerOrLoad(this.mTextureResourceId);
            this.sphereMeshWithTexture = new TexturedMesh(sphereMesh, currentTextureHanlde);
        }
    }

    public void resetCamera() {
        this.mModelScaleTarget = 1.0f;
        this.mModelRotationXTarget = 0.0f;
        this.mModelRotationYTarget = 0.0f;
        this.mModelRotationZTarget = 0.0f;
        this.mCameraZTarget = 1.0f;
    }

    public float getModelScale() {
        return this.mModelScale;
    }

    public void setModelScale(float scale) {
        if ((double)scale < 0.3) {
            scale = 0.3f;
        }
        if ((double)scale > 1.5) {
            scale = 1.5f;
        }
        this.mModelScale = scale;
        this.mModelScaleTarget = scale;
    }

    public float getModelRotationY() {
        return this.mModelRotationY;
    }

    public void setModelRotationY(float rotY) {
        this.mModelRotationY = rotY;
        this.mModelRotationYTarget = rotY;
    }

    public void setModelRotationZ(float rotZ) {
        this.mModelRotationZ = rotZ;
        this.mModelRotationZTarget = rotZ;
    }

    public synchronized void setModelRotationMatrix(float[] matrix) {
        this.mModelRotationMatrix = matrix;
    }

    public void setVelocities(float x, float y) {
        this.velocityX = x;
        this.velocityY = y;
    }

    public float getModelRotationX() {
        return this.mModelRotationX;
    }

    public void setModelRotationX(float rotX) {
        this.mModelRotationX = rotX;
        this.mModelRotationXTarget = rotX;
    }

    public void resetModelScale(float defaultScale) {
        this.mModelScaleTarget = defaultScale;
    }

    private float lerp(float t, float a, float b) {
        return (1.0f - t) * a + t * b;
    }

    public synchronized void onDrawFrame(GL10 gl) {
        GLES20.glClear((int)16640);
        if (this.firstFrame) {
            this.firstFrame = false;
            this.mModelRotationX = 30.0f;
            this.mModelRotationXTarget = 0.0f;
            this.mModelRotationY = 80.0f;
            this.mModelRotationYTarget = 0.0f;
            this.mModelScaleTarget = 1.0f;
            this.mModelScale = 1.0f;
            Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
        }
        long deltaTime = 1L;
        if (this.mLastTime == -1L) {
            this.mLastTime = System.currentTimeMillis();
        } else {
            long millis = System.currentTimeMillis();
            deltaTime = millis - this.mLastTime;
            this.mLastTime = millis;
        }
        float deltaTimeF = (float)deltaTime / 1000.0f;
        this.speedX -= this.speedX * this.fractionPerMs * deltaTimeF;
        this.speedY -= this.speedY * this.fractionPerMs * deltaTimeF;
        float currentTranslationX = this.speedX * deltaTimeF;
        float currentTranslationY = this.speedY * deltaTimeF;
        float fov = this.mModelScale * 100.0f;
        if (fov > 150.0f) {
            fov = 100.0f;
        }
        if (fov < 30.0f) {
            fov = 30.0f;
        }
        this.mModelScale = fov / 100.0f;
        PerspectiveMatrix.perspectiveM(this.mProjectionMatrix, 0, fov, this.ratio, 0.25f, 100.0f);
        float factor = (float)deltaTime / 10000.0f;
        this.setModelRotationY(this.getModelRotationY() + this.velocityX * factor);
        float xrot = this.getModelRotationX() + this.velocityY * factor;
        xrot = Math.max(Math.min(xrot, PanoramaGLSurfaceView.MAX_X_ROT), PanoramaGLSurfaceView.MIN_X_ROT);
        this.setModelRotationX(xrot);
        this.velocityY *= 1.0f - factor * 50.0f;
        this.velocityX *= 1.0f - factor * 50.0f;
        this.mModelScale = this.lerp(factor, this.mModelScale, this.mModelScaleTarget);
        this.mModelRotationX = this.lerp(factor, this.mModelRotationX, this.mModelRotationXTarget);
        this.mModelRotationY = this.lerp(factor, this.mModelRotationY, this.mModelRotationYTarget);
        this.mModelRotationZ = this.lerp(factor, this.mModelRotationZ, this.mModelRotationZTarget);
        this.mCameraZ = this.lerp(factor, this.mCameraZ, this.mCameraZTarget);
        float eyeX = 0.0f;
        float eyeY = 0.0f;
        float eyeZ = 0.0f;
        float lookX = 0.0f;
        float lookY = 0.0f;
        float lookZ = -5.0f;
        float upX = 0.0f;
        float upY = 1.0f;
        float upZ = 0.0f;
        Matrix.setLookAtM((float[])this.mViewMatrix, (int)0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GLES20.glUseProgram((int)this.mPerVertexProgramHandle);
        this.mMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mPerVertexProgramHandle, (String)"u_MVPMatrix");
        this.mMVMatrixHandle = GLES20.glGetUniformLocation((int)this.mPerVertexProgramHandle, (String)"u_MVMatrix");
        this.mLightPosHandle = GLES20.glGetUniformLocation((int)this.mPerVertexProgramHandle, (String)"u_LightPos");
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mPerVertexProgramHandle, (String)"a_Position");
        this.mColorHandle = GLES20.glGetUniformLocation((int)this.mPerVertexProgramHandle, (String)"u_Color");
        this.mNormalHandle = GLES20.glGetAttribLocation((int)this.mPerVertexProgramHandle, (String)"a_Normal");
        this.mTextureUniformHandle = GLES20.glGetUniformLocation((int)this.mPerVertexProgramHandle, (String)"u_Texture");
        this.mTextureCoordinateHandle = GLES20.glGetAttribLocation((int)this.mPerVertexProgramHandle, (String)"a_TexCoordinate");
        Matrix.setIdentityM((float[])this.mLightModelMatrix, (int)0);
        Matrix.translateM((float[])this.mLightModelMatrix, (int)0, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.multiplyMV((float[])this.mLightPosInWorldSpace, (int)0, (float[])this.mLightModelMatrix, (int)0, (float[])this.mLightPosInModelSpace, (int)0);
        Matrix.multiplyMV((float[])this.mLightPosInEyeSpace, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mLightPosInWorldSpace, (int)0);
        Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
        if (this.mModelRotationMatrix != null) {
            float[] v = this.convertM9toM16(this.mModelRotationMatrix, this.mModelMatrix);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.multiplyMM((float[])this.mModelMatrix, (int)0, (float[])v, (int)0, (float[])this.mModelMatrix, (int)0);
        } else {
            Matrix.multiplyMM((float[])this.mModelMatrix, (int)0, (float[])this.mModelMatrix, (int)0, (float[])this.touchRotationMatrix, (int)0);
        }
        this.drawMesh(this.sphereMeshWithTexture, this.mProjectionMatrix);
        this.rotate(currentTranslationX, currentTranslationY, true);
    }

    private float[] convertM9toM16(float[] m9, float[] m16) {
        float[] v = new float[]{m9[0], m9[1], m9[2], m16[3], m9[3], m9[4], m9[5], m16[7], m9[6], m9[7], m9[8], m16[11], m16[12], m16[13], m16[14], m16[15]};
        return v;
    }

    public static void transposeM(float[] mTrans, int mTransOffset, float[] m, int mOffset) {
        for (int i = 0; i < 3; ++i) {
            int mBase = i * 3 + mOffset;
            mTrans[i + mTransOffset] = m[mBase];
            mTrans[i + 3 + mTransOffset] = m[mBase + 1];
            mTrans[i + 6 + mTransOffset] = m[mBase + 2];
        }
    }

    public void drawMesh(TexturedMesh mesh, float[] mProjectionMatrix) {
        FloatBuffer positionsBuffer = mesh.getMesh().getPositionsBuffer();
        FloatBuffer normalsBuffer = mesh.getMesh().getNormalsBuffer();
        FloatBuffer uvsBuffer = mesh.getMesh().getUVsBuffer();
        float[] color = mesh.getMesh().getColor();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)mesh.getTextureDataHandle());
        GLES20.glUniform1i((int)this.mTextureUniformHandle, (int)0);
        positionsBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mPositionHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)positionsBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        normalsBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mNormalHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)normalsBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mNormalHandle);
        uvsBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mTextureCoordinateHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)uvsBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mTextureCoordinateHandle);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mModelMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mMVMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])mProjectionMatrix, (int)0, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniform3f((int)this.mLightPosHandle, (float)this.mLightPosInEyeSpace[0], (float)this.mLightPosInEyeSpace[1], (float)this.mLightPosInEyeSpace[2]);
        GLES20.glUniform4f((int)this.mColorHandle, (float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        GLES20.glDrawArrays((int)4, (int)0, (int)mesh.getMesh().getSize());
        if (this.runnableToDo != null) {
            this.runnableToDo.run();
            this.runnableToDo = null;
        }
    }

    public void setTex_resourceID(final int tex_resourceID) {
        this.runnableToDo = new Runnable(){

            @Override
            public void run() {
                int textureHandle = PanoramaRenderer.this.mImageDrawer.getTextureHandlerOrLoad(tex_resourceID);
                int toRemoveHandle = PanoramaRenderer.this.sphereMeshWithTexture.setTextureDataHandle(textureHandle);
                if (toRemoveHandle != -1) {
                    PanoramaRenderer.this.mImageDrawer.releaseHandle(toRemoveHandle);
                }
            }
        };
    }

    public void setTextureBitmap(final Bitmap bitmap) {
        this.runnableToDo = new Runnable(){

            @Override
            public void run() {
                int textureHandle = PanoramaRenderer.this.mImageDrawer.getTextureHandlerOrLoad(bitmap);
                int toRemoveHandle = PanoramaRenderer.this.sphereMeshWithTexture.setTextureDataHandle(textureHandle);
                if (toRemoveHandle != -1) {
                    PanoramaRenderer.this.mImageDrawer.releaseHandle(toRemoveHandle);
                }
            }
        };
    }

    public void initTouchRotation() {
        Matrix.setIdentityM((float[])this.touchRotationMatrix, (int)0);
    }

    public void rotate(float x, float y) {
        this.rotate(x, y, false);
    }

    public void rotate(float x, float y, boolean bySpeed) {
        if (!bySpeed) {
            this.speedX = 0.0f;
            this.speedY = 0.0f;
        }
        float[] identity = new float[16];
        Matrix.setIdentityM((float[])identity, (int)0);
        Matrix.rotateM((float[])identity, (int)0, (float)x, (float)0.0f, (float)1.0f, (float)0.0f);
        float[] v = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
        Matrix.multiplyMV((float[])v, (int)0, (float[])identity, (int)0, (float[])v, (int)0);
        Matrix.rotateM((float[])identity, (int)0, (float)y, (float)v[0], (float)v[1], (float)v[2]);
        Matrix.multiplyMM((float[])this.touchRotationMatrix, (int)0, (float[])identity, (int)0, (float[])this.touchRotationMatrix, (int)0);
    }

    public void rotateZ(float z) {
        float[] identity = new float[16];
        Matrix.setIdentityM((float[])identity, (int)0);
        Matrix.rotateM((float[])identity, (int)0, (float)z, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.multiplyMM((float[])this.touchRotationMatrix, (int)0, (float[])identity, (int)0, (float[])this.touchRotationMatrix, (int)0);
    }

    public void rotateRight(float v) {
        Matrix.rotateM((float[])this.touchRotationMatrix, (int)0, (float)v, (float)this.up[0], (float)this.up[1], (float)this.up[2]);
        float[] identity = new float[16];
        Matrix.setIdentityM((float[])identity, (int)0);
        Matrix.rotateM((float[])identity, (int)0, (float)v, (float)this.up[0], (float)this.up[1], (float)this.up[2]);
        Matrix.multiplyMV((float[])this.right, (int)0, (float[])identity, (int)0, (float[])this.right, (int)0);
        Log.d((String)"right", (String)String.format("(%f, %f, %f)", Float.valueOf(this.right[0]), Float.valueOf(this.right[1]), Float.valueOf(this.right[2])));
    }

    public void rotateUp(float v) {
        Matrix.rotateM((float[])this.touchRotationMatrix, (int)0, (float)v, (float)this.right[0], (float)this.right[1], (float)this.right[2]);
        float[] identity = new float[16];
        Matrix.setIdentityM((float[])identity, (int)0);
        Matrix.rotateM((float[])identity, (int)0, (float)v, (float)this.right[0], (float)this.right[1], (float)this.right[2]);
    }
}

