/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.viewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import java.util.Timer;
import java.util.TimerTask;
import pl.rjuszczyk.panorama.R;
import pl.rjuszczyk.panorama.gyroscope.GyroscopeHandler;
import pl.rjuszczyk.panorama.multitouch.MoveGestureDetector;
import pl.rjuszczyk.panorama.multitouch.RotateGestureDetector;
import pl.rjuszczyk.panorama.viewer.PanoramaRenderer;
import pl.rjuszczyk.panorama.viewer.RawImageDrawer;

public class PanoramaGLSurfaceView
extends GLSurfaceView {
    public static float MAX_X_ROT = 88.0f;
    public static float MIN_X_ROT = -88.0f;
    private float DEFAULT_TOUCH_SCALE = 0.2f;
    private float TOUCH_SCALE = 0.2f;
    MoveGestureDetector mMoveDetector;
    RawImageDrawer mImageDrawer;
    RotateGestureDetector mRotateGestureDetector;
    GestureDetector mFlingDetector;
    GyroscopeHandler gyroscopeHandler;
    GyroscopeHandler gyroscopeHandler2;
    private float mDefaultModelScale = 1.0f;
    private PanoramaRenderer mPanoramaRenderer;
    private float mScaleFactor = 1.0f;
    private float xrot;
    private float yrot;
    int beginEvents = 0;
    private ScaleGestureDetector mScaleGestureDetector;
    private boolean isGyroAvailable;
    private int currentGyroHandler = 1;
    private float[] currentRotationMatrix;
    private float[] currentRotationMatrix2;
    private float currentProgress = 0.0f;
    private int targetProgress;
    private long lastTime = System.currentTimeMillis();
    boolean autoCorrection = false;
    private Timer timer;

    public PanoramaGLSurfaceView(Context context) {
        super(context);
        if (this.isInEditMode()) {
            return;
        }
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mMoveDetector = new MoveGestureDetector(context, new MoveListener());
        this.mRotateGestureDetector = new RotateGestureDetector(context, new MyRotateGestureDetector());
        this.mScaleFactor = this.mDefaultModelScale;
        this.mImageDrawer = new RawImageDrawer(this.getResources());
        this.mPanoramaRenderer = new PanoramaRenderer(context, this.mImageDrawer, R.raw.sphere);
        this.mPanoramaRenderer.setModelScale(this.mDefaultModelScale);
        this.setEGLContextClientVersion(2);
        this.setRenderer(this.mPanoramaRenderer);
    }

    public PanoramaGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mMoveDetector = new MoveGestureDetector(context, new MoveListener());
        this.mRotateGestureDetector = new RotateGestureDetector(context, new MyRotateGestureDetector());
        this.mFlingDetector = new GestureDetector(this.getContext(), new GestureDetector.OnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                ((PanoramaGLSurfaceView)PanoramaGLSurfaceView.this).mPanoramaRenderer.speedX = -PanoramaGLSurfaceView.this.TOUCH_SCALE * velocityX;
                ((PanoramaGLSurfaceView)PanoramaGLSurfaceView.this).mPanoramaRenderer.speedY = -PanoramaGLSurfaceView.this.TOUCH_SCALE * velocityY;
                return false;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onDown(MotionEvent motionEvent) {
                return false;
            }

            public void onShowPress(MotionEvent motionEvent) {
            }

            public boolean onSingleTapUp(MotionEvent event) {
                return false;
            }

            public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent1, float v, float v1) {
                return false;
            }
        });
        this.mScaleFactor = this.mDefaultModelScale;
        this.mImageDrawer = new RawImageDrawer(this.getResources());
        this.mPanoramaRenderer = new PanoramaRenderer(context, this.mImageDrawer, R.raw.sphere);
        this.mPanoramaRenderer.setModelScale(this.mDefaultModelScale);
        this.setEGLContextClientVersion(2);
        this.setRenderer(this.mPanoramaRenderer);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retVal = this.mRotateGestureDetector.onTouchEvent(event);
        retVal = this.mScaleGestureDetector.onTouchEvent(event) || retVal;
        retVal = this.mMoveDetector.onTouchEvent(event) || retVal;
        retVal = this.mFlingDetector.onTouchEvent(event) || retVal;
        return retVal || super.onTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        this.gyroscopeHandler.stop();
        this.gyroscopeHandler2.stop();
        if (this.autoCorrection) {
            this.timer.cancel();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.gyroscopeHandler = new GyroscopeHandler();
        this.gyroscopeHandler2 = new GyroscopeHandler();
        this.currentGyroHandler = 2;
        this.isGyroAvailable = true;
        this.gyroscopeHandler.start(this.getContext(), new GyroscopeHandler.OnGyroscopeChanged(){

            @Override
            public void onGyroscopeChange(double x, double y, double z) {
            }

            @Override
            public void onGyroscopeChanged2(float[] currentRotationMatrix) {
                if (PanoramaGLSurfaceView.this.isGyroAvailable) {
                    PanoramaGLSurfaceView.access$602(PanoramaGLSurfaceView.this, currentRotationMatrix);
                    if (PanoramaGLSurfaceView.this.currentGyroHandler == 2) {
                        float deltaTime = System.currentTimeMillis() - PanoramaGLSurfaceView.this.lastTime;
                        PanoramaGLSurfaceView.this.lastTime = System.currentTimeMillis();
                        PanoramaGLSurfaceView.this.currentProgress = PanoramaGLSurfaceView.this.lerp(0.01f, PanoramaGLSurfaceView.this.currentProgress, PanoramaGLSurfaceView.this.targetProgress);
                        if ((double)PanoramaGLSurfaceView.this.currentProgress < 0.01 && PanoramaGLSurfaceView.this.targetProgress == 0) {
                            PanoramaGLSurfaceView.this.currentProgress = 0.0f;
                        }
                        if ((double)PanoramaGLSurfaceView.this.currentProgress > 0.99 && PanoramaGLSurfaceView.this.targetProgress == 1) {
                            PanoramaGLSurfaceView.this.currentProgress = 1.0f;
                        }
                        Log.d((String)"gyro1", (String)("onGyroscopeChanged2: currentProgress = " + PanoramaGLSurfaceView.this.currentProgress));
                    } else {
                        if (PanoramaGLSurfaceView.this.currentRotationMatrix == null || PanoramaGLSurfaceView.this.currentRotationMatrix2 == null) {
                            return;
                        }
                        float[] rotationMatrix = PanoramaGLSurfaceView.this.getCurrentRotationMatrix(PanoramaGLSurfaceView.this.currentRotationMatrix, PanoramaGLSurfaceView.this.currentRotationMatrix2, PanoramaGLSurfaceView.this.currentProgress);
                        PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationMatrix(rotationMatrix);
                    }
                }
            }

            @Override
            public void onGyroscopeNotAvailable() {
                PanoramaGLSurfaceView.this.isGyroAvailable = false;
            }
        });
        this.gyroscopeHandler2.start(this.getContext(), new GyroscopeHandler.OnGyroscopeChanged(){

            @Override
            public void onGyroscopeChange(double x, double y, double z) {
            }

            @Override
            public void onGyroscopeChanged2(float[] currentRotationMatrix) {
                if (PanoramaGLSurfaceView.this.isGyroAvailable) {
                    PanoramaGLSurfaceView.access$1102(PanoramaGLSurfaceView.this, currentRotationMatrix);
                    if (PanoramaGLSurfaceView.this.currentGyroHandler == 1) {
                        float deltaTime = System.currentTimeMillis() - PanoramaGLSurfaceView.this.lastTime;
                        PanoramaGLSurfaceView.this.lastTime = System.currentTimeMillis();
                        PanoramaGLSurfaceView.this.currentProgress = PanoramaGLSurfaceView.this.lerp(0.01f, PanoramaGLSurfaceView.this.currentProgress, PanoramaGLSurfaceView.this.targetProgress);
                        Log.d((String)"gyro2", (String)("onGyroscopeChanged2: currentProgress = " + PanoramaGLSurfaceView.this.currentProgress));
                        if ((double)PanoramaGLSurfaceView.this.currentProgress < 0.01 && PanoramaGLSurfaceView.this.targetProgress == 0) {
                            PanoramaGLSurfaceView.this.currentProgress = 0.0f;
                        }
                        if ((double)PanoramaGLSurfaceView.this.currentProgress > 0.99 && PanoramaGLSurfaceView.this.targetProgress == 1) {
                            PanoramaGLSurfaceView.this.currentProgress = 1.0f;
                        }
                    } else {
                        if (PanoramaGLSurfaceView.this.currentRotationMatrix == null || PanoramaGLSurfaceView.this.currentRotationMatrix2 == null) {
                            return;
                        }
                        float[] rotationMatrix = PanoramaGLSurfaceView.this.getCurrentRotationMatrix(PanoramaGLSurfaceView.this.currentRotationMatrix, PanoramaGLSurfaceView.this.currentRotationMatrix2, PanoramaGLSurfaceView.this.currentProgress);
                        PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationMatrix(rotationMatrix);
                    }
                }
            }

            @Override
            public void onGyroscopeNotAvailable() {
                PanoramaGLSurfaceView.this.isGyroAvailable = false;
            }
        });
        if (this.autoCorrection) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    PanoramaGLSurfaceView.this.reset();
                }
            }, 0L, 10000L);
        }
    }

    float[] getCurrentRotationMatrix(float[] matrix1, float[] matrix2, float progress) {
        float[] matrixResult = new float[matrix1.length];
        for (int i = 0; i < matrix1.length; ++i) {
            matrixResult[i] = this.lerp(progress, matrix1[i], matrix2[i]);
        }
        return matrixResult;
    }

    float lerp(float t, float a, float b) {
        return (1.0f - t) * a + t * b;
    }

    public void reset() {
        Log.d((String)"Panorama", (String)"reset() called");
        if (this.currentGyroHandler == 1) {
            this.gyroscopeHandler.reset();
            this.gyroscopeHandler.restart();
            this.currentGyroHandler = 2;
            this.targetProgress = 0;
        } else {
            this.gyroscopeHandler2.reset();
            this.gyroscopeHandler2.restart();
            this.currentGyroHandler = 1;
            this.targetProgress = 1;
        }
    }

    public void setPanoramaResourceId(int tex_resourceID) {
        this.mPanoramaRenderer.setTex_resourceID(tex_resourceID);
    }

    public void setTexDrawableResourceID(int tex_resourceID) {
        this.mPanoramaRenderer.setTex_resourceID(tex_resourceID);
    }

    public void setPanoramaBitmap(Bitmap bitmap) {
        this.mPanoramaRenderer.setTextureBitmap(bitmap);
    }

    static /* synthetic */ float[] access$602(PanoramaGLSurfaceView x0, float[] x1) {
        x0.currentRotationMatrix = x1;
        return x1;
    }

    static /* synthetic */ float[] access$1102(PanoramaGLSurfaceView x0, float[] x1) {
        x0.currentRotationMatrix2 = x1;
        return x1;
    }

    private class MoveListener
    implements MoveGestureDetector.OnMoveGestureListener {
        private MoveListener() {
        }

        @Override
        public boolean onMove(MoveGestureDetector detector) {
            if (PanoramaGLSurfaceView.this.beginEvents != 0) {
                return true;
            }
            float distanceX = detector.getFocusDelta().x;
            float distanceY = detector.getFocusDelta().y;
            PanoramaGLSurfaceView.this.mPanoramaRenderer.rotate(-distanceX * PanoramaGLSurfaceView.this.TOUCH_SCALE, -distanceY * PanoramaGLSurfaceView.this.TOUCH_SCALE);
            return true;
        }

        @Override
        public boolean onMoveBegin(MoveGestureDetector detector) {
            return true;
        }

        @Override
        public void onMoveEnd(MoveGestureDetector detector) {
        }
    }

    private class MyRotateGestureDetector
    implements RotateGestureDetector.OnRotateGestureListener {
        private MyRotateGestureDetector() {
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            PanoramaGLSurfaceView.this.mPanoramaRenderer.rotateZ(detector.getRotationDegreesDelta());
            return true;
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            ++PanoramaGLSurfaceView.this.beginEvents;
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            --PanoramaGLSurfaceView.this.beginEvents;
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            PanoramaGLSurfaceView.this.mScaleFactor = PanoramaGLSurfaceView.this.mPanoramaRenderer.getModelScale() / detector.getScaleFactor();
            PanoramaGLSurfaceView.this.mScaleFactor = Math.max(0.3f, Math.min(PanoramaGLSurfaceView.this.mScaleFactor, 1.5f));
            PanoramaGLSurfaceView.this.TOUCH_SCALE = PanoramaGLSurfaceView.this.DEFAULT_TOUCH_SCALE * PanoramaGLSurfaceView.this.mScaleFactor;
            PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelScale(PanoramaGLSurfaceView.this.mScaleFactor);
            PanoramaGLSurfaceView.this.invalidate();
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ++PanoramaGLSurfaceView.this.beginEvents;
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            --PanoramaGLSurfaceView.this.beginEvents;
            super.onScaleEnd(detector);
        }
    }
}

