package pl.redlink.push.web

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import android.view.MenuItem
import android.webkit.WebView
import android.webkit.WebViewClient
import pl.redlink.push.R


class WebviewActivity : AppCompatActivity() {

    companion object {

        const val EXTRA_URL = "pl.redlink.push.web.extra-url"

        fun openUri(context: Context, url: String) {
            val intent = Intent(context, WebviewActivity::class.java)
            intent.putExtra(WebviewActivity.EXTRA_URL, url)
            context.startActivity(intent)
        }

    }

    @SuppressLint("SetJavaScriptEnabled")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.redlink_activity_webview)
        val url = intent.getStringExtra(EXTRA_URL)
        title = url
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        findViewById<WebView>(R.id.webview).apply {
            webViewClient = WebViewClient()
            settings.javaScriptEnabled = true
            loadUrl(url)
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                finish()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

}