package pl.redlink.push.service.model

import org.json.JSONObject

internal open class CustomData {

    var booleanFields: MutableMap<String, Boolean> = mutableMapOf()

    var integerFields: MutableMap<String, Int> = mutableMapOf()

    var stringFields: MutableMap<String, String> = mutableMapOf()

    var dateFields: MutableMap<String, Int> = mutableMapOf()

    val allFields: MutableMap<String, Any>
        get() {
            return mutableMapOf<String, Any>().apply {
                putAll(booleanFields)
                putAll(integerFields)
                putAll(stringFields)
                putAll(dateFields)
            }
        }

    internal open fun toJsonObject(): JSONObject? =
            JSONObject().apply {
                put(JSON_KEY_BOOLEAN_FIELDS, JSONObject(booleanFields))
                put(JSON_KEY_INTEGER_FIELDS, JSONObject(integerFields))
                put(JSON_KEY_STRING_FIELDS, JSONObject(stringFields))
                put(JSON_KEY_DATE_FIELDS, JSONObject(dateFields))
            }

    companion object {
        private const val JSON_KEY_BOOLEAN_FIELDS = "boolean_fields"
        private const val JSON_KEY_INTEGER_FIELDS = "integer_fields"
        private const val JSON_KEY_STRING_FIELDS = "string_fields"
        private const val JSON_KEY_DATE_FIELDS = "date_fields"
    }

}