package pl.redlink.push.provider

import android.content.Context
import pl.redlink.push.manager.PREFS_KEY_UUID
import pl.redlink.push.manager.PREFS_NAME
import java.util.*

object UuidProvider {

    fun provideUuid(context: Context): String? {
        createUuidIfNotExists(context)
        return context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE).getString(
            PREFS_KEY_UUID, UUID.randomUUID().toString()
        )
    }

    private fun createUuidIfNotExists(context: Context) {
        val prefs = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
        val hasUuid = prefs.contains(PREFS_KEY_UUID)
        if (!hasUuid) prefs.edit().putString(PREFS_KEY_UUID, UUID.randomUUID().toString()).apply()
    }

}