package pl.redlink.push.manager.user

import org.json.JSONException
import org.json.JSONObject
import java.util.*

internal object CustomUserData {

    private const val JSON_KEY_API_LEVEL = "level"
    private const val JSON_KEY_LANGUAGE = "language"
    private const val JSON_KEY_MANUFACTURER = "manufacturer"
    private const val JSON_KEY_MODEL = "model"
    private const val JSON_KEY_OS_VERSION = "os-version"
    private const val JSON_KEY_TIME_ZONE = "time-zone"

    val apiLevel = android.os.Build.VERSION.SDK_INT.toString()
    val language
        get() = Locale.getDefault().language
    val manufacturer = android.os.Build.MANUFACTURER
    val model = android.os.Build.MODEL
    val osVersion = android.os.Build.VERSION.RELEASE
    val timeZone = TimeZone.getDefault().id

    fun toJsonObject(): JSONObject? =
            try {
                JSONObject().apply {
                    put(JSON_KEY_API_LEVEL, apiLevel)
                    put(JSON_KEY_LANGUAGE, language)
                    put(JSON_KEY_MANUFACTURER, manufacturer)
                    put(JSON_KEY_MODEL, model)
                    put(JSON_KEY_OS_VERSION, osVersion)
                    put(JSON_KEY_TIME_ZONE, timeZone)
                }
            } catch (e: JSONException) {
                null
            }


    fun toJsonString(): String? = toJsonObject().toString()

}
