package pl.redlink.push.lifecycle

import android.app.Activity
import android.content.Context
import pl.redlink.push.Logger
import pl.redlink.push.RedlinkApp
import pl.redlink.push.service.EventsService
import pl.redlink.push.service.RegisterDeviceService
import pl.redlink.push.ui.InAppPushManager

internal class AppLifecycleDelegateHandler(private val inAppPushManager: InAppPushManager) : AppLifecycleDelegate {

    private var context: Context? = null

    override fun init(context: Context) {
        this.context = context
    }

    override fun onAppInBackground() {
        Logger.info("App is in background")
        context?.let { checkEvents(it) }
    }

    override fun onAppInForeground(context: Context?) {
        Logger.info("App is in foreground")
        context?.let {
            registerDevice(it)
            checkEvents(it)
            handleLastPush(it)
        }
    }

    private fun registerDevice(context: Context) {
        RegisterDeviceService.enqueueRequest(context)
    }

    private fun checkEvents(context: Context) {
        EventsService.enqueueRequest(context)
    }

    private fun handleLastPush(context: Context) {
        if (context is Activity && !context.isFinishing) {
            inAppPushManager.checkPushes(context)
        }
    }

}