package pl.redlink.push.http

import java.io.InputStream

data class Response(
        val url: String,
        val status: Int = -1,
        val stream: InputStream? = null,
        val headers: Map<String, List<String>> = emptyMap(),
        val error: Throwable? = null
) {

    val body = stream?.readBytes()?.toString(Charsets.UTF_8)

    fun isSuccess() = status in (200..299)

}