package pl.redlink.push.fcm.notification.extender

import android.content.Context
import androidx.core.app.NotificationCompat
import pl.redlink.push.extension.getDrawableResourceIdByName
import pl.redlink.push.fcm.PushMessage
import pl.redlink.push.media.getIcon
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.runBlocking

import kotlinx.coroutines.withContext

internal class ImageExtender(private val context: Context, private val pushMessage: PushMessage) : NotificationCompat.Extender {

    override fun extend(builder: NotificationCompat.Builder): NotificationCompat.Builder {
        pushMessage.apply {
            image?.also {
                runBlocking {
                    withContext(Dispatchers.Default) { getIcon(it) }?.let { bitmap ->
                        builder.setStyle(NotificationCompat.BigPictureStyle().bigPicture(bitmap))
                    }
                }
            }

            largeIcon?.also {
                runBlocking {
                    withContext(Dispatchers.Default) { getIcon(it) }?.let { bitmap ->
                        builder.setLargeIcon(bitmap)
                    }
                }
            }

            smallIcon?.also {
                context.getDrawableResourceIdByName(it)?.let { drawableResId ->
                    builder.setSmallIcon(drawableResId)
                }

            }
        }
        return builder
    }

}
