package pl.redlink.push.fcm.action

import android.content.Context
import android.content.Intent
import android.content.Intent.FLAG_ACTIVITY_NEW_TASK
import android.content.Intent.FLAG_ACTIVITY_SINGLE_TOP
import android.net.Uri
import pl.redlink.push.di.redlink
import pl.redlink.push.extension.canBeHandled
import pl.redlink.push.fcm.CustomTabProvider
import pl.redlink.push.fcm.NotificationActionBroadcast
import pl.redlink.push.fcm.PushMessage
import pl.redlink.push.web.CustomTabsHelper
import pl.redlink.push.web.WebviewActivity

class ActionProcessor(private val customTabProvider: CustomTabProvider = redlink().customTabProvider) {

    fun runApp(context: Context?, pushMessage: PushMessage? = null, action: Action? = null) {
        val runIntent = context?.packageManager?.getLaunchIntentForPackage(context.packageName)
        runIntent?.also {
            it.flags = FLAG_ACTIVITY_SINGLE_TOP or FLAG_ACTIVITY_NEW_TASK
            pushMessage?.also { pushMessage ->
                it.putExtra(NotificationActionBroadcast.EXTRA_PUSH_MESSAGE, pushMessage)
            }
            action?.also { action ->
                it.putExtra(NotificationActionBroadcast.EXTRA_ACTION, action)
            }
            context.startActivity(it)
        }
    }

    fun runDeeplink(context: Context?, action: Action) {
        action.url?.let { url ->
            val intent = Intent(Intent.ACTION_VIEW).apply { data = Uri.parse(url) }
            intent.flags = FLAG_ACTIVITY_SINGLE_TOP or FLAG_ACTIVITY_NEW_TASK or FLAG_ACTIVITY_NEW_TASK
            context?.startActivity(intent)
        }
    }

    fun runBrowser(context: Context?, action: Action) {
        context?.also { ctx ->
            action.url?.let { url ->
                val defaultBrowser = Intent.makeMainSelectorActivity(Intent.ACTION_MAIN, Intent.CATEGORY_APP_BROWSER)
                if (defaultBrowser.canBeHandled(context)) {
                    defaultBrowser.data = Uri.parse(url)
                    defaultBrowser.flags = FLAG_ACTIVITY_SINGLE_TOP or FLAG_ACTIVITY_NEW_TASK
                    context.startActivity(defaultBrowser)
                }
            }
        }
    }

    fun runWebview(context: Context?, action: Action) {
        context?.also { ctx ->
            action.url?.let { url ->
                val packageName = CustomTabsHelper.getPackageNameToUse(context)
                val intent = Intent().apply {
                    data = Uri.parse(url)
                }
                if (packageName != null && intent.canBeHandled(context)) {
                    customTabProvider.customTabBuilder.build().also {
                        it.intent.setPackage(packageName)
                        it.launchUrl(context, Uri.parse(url))
                    }
                } else {
                    WebviewActivity.openUri(ctx, url)
                }
            }
        }
    }

}