package pl.redlink.push.extension

import java.io.*

internal fun empty() = ByteArrayInputStream(ByteArray(0))

// TODO: use UTF-8
internal fun Any.toByteArray(): ByteArray? {
    try {
        ByteArrayOutputStream().use { byteArrayOutputStream ->
            ObjectOutputStream(byteArrayOutputStream).use { objectOutputStream ->
                objectOutputStream.writeObject(this)
                return byteArrayOutputStream.toByteArray()
            }
        }
    } catch (ioException: IOException) {
        return null
    }
}

// TODO: use UTF-8
internal fun ByteArray.toAny(): Any? {
    try {
        ByteArrayInputStream(this).use { byteArrayInputStream ->
            ObjectInputStream(byteArrayInputStream).use { objectInputStream ->
                return objectInputStream.readObject()
            }
        }
    } catch (ioException: IOException) {
        return null
    }
}
