package pl.redlink.push.extension

import android.content.Context
import android.content.Intent


internal fun <T> toEnumOrNull(enumClass: Class<T>, name: String?, ignoreCase: Boolean = true): T? =
        enumClass.enumConstants.firstOrNull {
            name.equals((it as? Enum<*>)?.name, ignoreCase = ignoreCase)
        }

internal fun <T> toEnumOrDefault(enumClass: Class<T>, name: String?, defaultEnum: T, ignoreCase: Boolean = true): T =
        toEnumOrNull(enumClass, name, ignoreCase) ?: defaultEnum

internal infix fun <T : Any> T?.ifNull(block: () -> Unit): T? {
    if (this == null) block()
    return this
}

internal inline fun Boolean.alsoIfTrue(block: (Boolean) -> Unit): Boolean {
    if (this) block(this)
    return this
}

internal fun Intent.canBeHandled(context: Context): Boolean {
    val packageManager = context.packageManager
    return resolveActivity(packageManager) != null
}