package pl.redlink.push

import android.util.Log

internal object Logger {

    private const val TAG = "RedlinkApp"

    var enabled = false

    fun warning(warning: String) {
        if (Logger.enabled) {
            Log.w(Logger.TAG, warning)
        }
    }

    fun error(error: String) {
        if (Logger.enabled) {
            Log.e(Logger.TAG, error)
        }
    }

    fun info(info: String) {
        if (Logger.enabled) {
            Log.i(Logger.TAG, info)
        }
    }

    fun debug(debug: String) {
        if (Logger.enabled) {
            Log.d(Logger.TAG, debug)
        }
    }

    fun stackTrace(throwable: Throwable) {
        if (Logger.enabled) {
            throwable.printStackTrace()
        }
    }

}
