/*
 * Decompiled with CFR 0.152.
 */
package pl.redlink.push.service.repository;

import java.net.URL;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.redlink.push.di.RedlinkComponentKt;
import pl.redlink.push.http.Method;
import pl.redlink.push.http.Request;
import pl.redlink.push.http.Response;
import pl.redlink.push.http.RestClient;
import pl.redlink.push.provider.RedlinkIdProvider;
import pl.redlink.push.service.model.Device;
import pl.redlink.push.service.model.Status;
import pl.redlink.push.service.model.User;
import pl.redlink.push.service.repository.PushRepository;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lpl/redlink/push/service/repository/PushRepositoryImpl;", "Lpl/redlink/push/service/repository/PushRepository;", "restClient", "Lpl/redlink/push/http/RestClient;", "(Lpl/redlink/push/http/RestClient;)V", "lastPush", "Lpl/redlink/push/http/Response;", "registrationId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pushStatus", "status", "Lpl/redlink/push/service/model/Status;", "(Lpl/redlink/push/service/model/Status;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "registerDevice", "device", "Lpl/redlink/push/service/model/Device;", "(Lpl/redlink/push/service/model/Device;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateUserData", "user", "Lpl/redlink/push/service/model/User;", "(Ljava/lang/String;Lpl/redlink/push/service/model/User;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "push_release"})
public final class PushRepositoryImpl
implements PushRepository {
    private final RestClient restClient;
    private static final String BASE_URL = "https://push.redlink.pl/v1/";
    private static final String SEND_DEVICE_ENDPOINT = "devices/";
    private static final String AUTHORIZATION = "AShIxRSOf5G015lYhPIXGfcgmSkVgrrwddK";
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Object lastPush(@NotNull String registrationId, @NotNull Continuation<? super Response> $completion) {
        String string2 = "application/json";
        Map map = PushRepositoryImpl.Companion.getAuthorizationHeaders();
        return this.restClient.call(new Request(new URL(BASE_URL + PushRepositoryImpl.Companion.lastPushEndpoint(registrationId)), Method.GET, null, string2, map, 4, null));
    }

    @Override
    @Nullable
    public Object registerDevice(@NotNull Device device, @NotNull Continuation<? super Response> $completion) {
        String string2 = "application/json";
        Map map = PushRepositoryImpl.Companion.getAuthorizationHeaders();
        Method method = Method.POST;
        String string3 = device.toJson$push_release();
        return RestClient.asyncCallWithRetry$default(this.restClient, new Request(new URL("https://push.redlink.pl/v1/devices/"), method, string3, string2, map), 0, $completion, 2, null);
    }

    @Override
    @Nullable
    public Object updateUserData(@NotNull String registrationId, @NotNull User user, @NotNull Continuation<? super Response> $completion) {
        String string2 = "application/json";
        Map map = PushRepositoryImpl.Companion.getAuthorizationHeaders();
        Method method = Method.PATCH;
        String string3 = user.toJson$push_release();
        return RestClient.asyncCallWithRetry$default(this.restClient, new Request(new URL(BASE_URL + PushRepositoryImpl.Companion.updateUserData(registrationId)), method, string3, string2, map), 0, $completion, 2, null);
    }

    @Override
    @Nullable
    public Object pushStatus(@NotNull Status status, @NotNull Continuation<? super Response> $completion) {
        String string2 = "application/json";
        Map map = PushRepositoryImpl.Companion.getAuthorizationHeaders();
        Method method = Method.POST;
        String string3 = status.toJson$push_release();
        return RestClient.asyncCallWithRetry$default(this.restClient, new Request(new URL(BASE_URL + PushRepositoryImpl.Companion.reportsEndpoint(status.getId())), method, string3, string2, map), 0, $completion, 2, null);
    }

    public PushRepositoryImpl(@NotNull RestClient restClient) {
        Intrinsics.checkParameterIsNotNull((Object)restClient, (String)"restClient");
        this.restClient = restClient;
    }

    public /* synthetic */ PushRepositoryImpl(RestClient restClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            restClient = RedlinkComponentKt.redlink().getRestClient();
        }
        this(restClient);
    }

    public PushRepositoryImpl() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lpl/redlink/push/service/repository/PushRepositoryImpl$Companion;", "", "()V", "AUTHORIZATION", "", "BASE_URL", "SEND_DEVICE_ENDPOINT", "authorizationHeaders", "", "getAuthorizationHeaders", "()Ljava/util/Map;", "lastPushEndpoint", "id", "reportsEndpoint", "updateUserData", "push_release"})
    public static final class Companion {
        private final String reportsEndpoint(String id) {
            return "pushes/" + id + "/reports";
        }

        private final String lastPushEndpoint(String id) {
            return PushRepositoryImpl.SEND_DEVICE_ENDPOINT + id + "/last_push";
        }

        private final String updateUserData(String id) {
            return PushRepositoryImpl.SEND_DEVICE_ENDPOINT + id + "/user_data";
        }

        private final Map<String, String> getAuthorizationHeaders() {
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"Authorization", (Object)PushRepositoryImpl.AUTHORIZATION);
            String string2 = RedlinkIdProvider.INSTANCE.getRedlinkToken();
            String string3 = "X-Redlink-App-Token";
            int n = 1;
            Pair[] pairArray2 = pairArray;
            Pair[] pairArray3 = pairArray;
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            pairArray2[n] = TuplesKt.to((Object)string3, (Object)string5);
            string2 = RedlinkIdProvider.INSTANCE.getRedlinkSecret();
            string3 = "X-Redlink-App-Secret";
            n = 2;
            pairArray2 = pairArray3;
            bl = false;
            String string6 = string2;
            if (string6 == null) {
                string6 = "";
            }
            string5 = string6;
            pairArray2[n] = TuplesKt.to((Object)string3, (Object)string5);
            return MapsKt.mapOf((Pair[])pairArray3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

