package pl.redlink.push.service.repository

import pl.redlink.push.di.redlink
import pl.redlink.push.http.*
import pl.redlink.push.provider.RedlinkIdProvider
import pl.redlink.push.service.model.RedlinkEvent
import java.net.URL

internal class ApiRepositoryImpl(
        private val restClient: RestClient = redlink().restClient
) : ApiRepository {

    override suspend fun sendEvent(event: RedlinkEvent): Response {

        val authorizationHeaders = mapOf(
            "Authorization" to RedlinkIdProvider.getRedlinkEventsToken().orEmpty()
        )

        return restClient.call(
                Request(url = URL("$BASE_URL$SEND_EVENT"),
                        method = Method.POST,
                        body = event.toJsonObject().toString(),
                        headers = authorizationHeaders,
                        contentType = HttpClient.CONTENT_TYPE_JSON
                ))
    }

    companion object {

        private const val BASE_URL = "https://api.redlink.pl/v1/"
        private const val SEND_EVENT = "event"

    }

}
