package pl.redlink.push.service.model

import org.json.JSONObject

internal class RedlinkEvent(
        val pushId: String,
        val email: String?,
        val number: String?,
        val eventName: String,
        val createdAt: Long,
        val userData: String?
) : CustomData() {

    override fun toJsonObject(): JSONObject? =
            JSONObject().apply {
                put(JSON_KEY_BOOLEAN_FIELDS, JSONObject(booleanFields))
                put(JSON_KEY_INTEGER_FIELDS, JSONObject(integerFields))
                put(JSON_KEY_STRING_FIELDS, JSONObject(stringFields))
                put(JSON_KEY_DATE_FIELDS, JSONObject(dateFields))
                put(JSON_PUSH_ID, pushId)
                put(JSON_EMAIL, email)
                put(JSON_NUMBER, number)
                put(JSON_EVENT_NAME, eventName)
                put(JSON_CREATED_AT, createdAt)
                put(JSON_USER_DATA, userData)
            }

    companion object {

        private const val JSON_KEY_BOOLEAN_FIELDS = "additionalBoolFields"
        private const val JSON_KEY_INTEGER_FIELDS = "additionalNumericFields"
        private const val JSON_KEY_STRING_FIELDS = "additionalStringFields"
        private const val JSON_KEY_DATE_FIELDS = "additionalDateFields"
        private const val JSON_PUSH_ID = "pushId"
        private const val JSON_EMAIL = "email"
        private const val JSON_NUMBER = "number"
        private const val JSON_EVENT_NAME = "eventName"
        private const val JSON_CREATED_AT = "createdAt"
        private const val JSON_USER_DATA = "userData"

    }

}