package pl.redlink.push.service.model

import pl.redlink.push.extension.createJsonArrayOrNull
import pl.redlink.push.extension.mapNotNull
import org.json.JSONObject

const val KEY_KEY = "key"
const val KEY_VALUE = "value"

data class KeyValue(val key: String, val value: String) {

    companion object {

        fun fromJson(json: String?): List<KeyValue>? {
            return createJsonArrayOrNull(json)?.mapNotNull<JSONObject, KeyValue> {
                KeyValue(it.getString(KEY_KEY), it.getString(KEY_VALUE))
            }?.toList()
        }

    }

}