package pl.redlink.push.service

import android.content.Context
import android.content.Intent
import androidx.core.app.JobIntentService
import pl.redlink.push.Logger
import pl.redlink.push.di.RedlinkModule.pushRepository
import pl.redlink.push.manager.token.FcmTokenManager
import kotlinx.coroutines.runBlocking
import pl.redlink.push.service.model.User

class UserUpdateService : JobIntentService() {

    override fun onHandleWork(intent: Intent) {
        runBlocking {
            val savedFcmToken = FcmTokenManager.get()
            if (!savedFcmToken.isNullOrBlank()) {
                val response = pushRepository.updateUserData(savedFcmToken, User())
                if (response.isSuccess()) {
                    Logger.info("User updated successfully")
                } else {
                    Logger.error("User cannot be updated, please check your connection")
                }
            }
        }
    }

    companion object {
        private const val USER_UPDATE_JOB_ID = 4000
        fun enqueueRequest(context: Context) {
            val intent = Intent(context, UserUpdateService::class.java)
            enqueueWork(context, UserUpdateService::class.java, USER_UPDATE_JOB_ID, intent)
        }
    }

}