package pl.redlink.push.manager.user

import pl.redlink.push.extension.getMapOrNull
import pl.redlink.push.extension.getStringOrNull
import org.json.JSONException
import org.json.JSONObject

data class RedlinkUserData internal constructor(
        var email: String = "",
        var phone: String = "",
        var firstName: String = "",
        var lastName: String = "",
        var companyName: String = "",
        var customIntValues: MutableMap<String, Int> = mutableMapOf(),
        var customStringValues: MutableMap<String, String> = mutableMapOf(),
        var customBooleanValues: MutableMap<String, Boolean> = mutableMapOf(),
        var customDateValues: MutableMap<String, Int> = mutableMapOf()
) {

    internal val redlinkValues: Map<String, String>
        get() = mapOf(
                JSON_KEY_EMAIL to (email),
                JSON_KEY_PHONE to (phone),
                JSON_KEY_FIRST_NAME to (firstName),
                JSON_KEY_LAST_NAME to (lastName),
                JSON_KEY_COMPANY_NAME to (companyName))


    internal fun toJsonObject(): JSONObject? =
            try {
                JSONObject().apply {
                    put(JSON_KEY_EMAIL, email)
                    put(JSON_KEY_PHONE, phone)
                    put(JSON_KEY_FIRST_NAME, firstName)
                    put(JSON_KEY_LAST_NAME, lastName)
                    put(JSON_KEY_COMPANY_NAME, companyName)
                    put(JSON_KEY_CUSTOM_INT_VALUES, JSONObject(customIntValues))
                    put(JSON_KEY_CUSTOM_STRING_VALUES, JSONObject(customStringValues))
                    put(JSON_KEY_CUSTOM_BOOLEAN_VALUES, JSONObject(customBooleanValues))
                    put(JSON_KEY_CUSTOM_DATE_VALUES, JSONObject(customDateValues))
                }
            } catch (e: JSONException) {
                null
            }

    fun toJsonString(): String? = toJsonObject().toString()

    companion object {

        private const val JSON_KEY_EMAIL = "email"
        private const val JSON_KEY_PHONE = "number"
        private const val JSON_KEY_FIRST_NAME = "first_name"
        private const val JSON_KEY_LAST_NAME = "last_name"
        private const val JSON_KEY_COMPANY_NAME = "company_name"
        private const val JSON_KEY_CUSTOM_INT_VALUES = "custom_int_values"
        private const val JSON_KEY_CUSTOM_STRING_VALUES = "custom_string_values"
        private const val JSON_KEY_CUSTOM_BOOLEAN_VALUES = "custom_boolean_values"
        private const val JSON_KEY_CUSTOM_DATE_VALUES = "custom_date_values"

        internal fun fromJson(json: String): RedlinkUserData? {
            if (json.isBlank()) {
                return null
            }
            return RedlinkUserData().apply {
                JSONObject(json).also {
                    email = it.getStringOrNull(JSON_KEY_EMAIL) ?: ""
                    phone = it.getStringOrNull(JSON_KEY_PHONE) ?: ""
                    firstName = it.getStringOrNull(JSON_KEY_FIRST_NAME) ?: ""
                    lastName = it.getStringOrNull(JSON_KEY_LAST_NAME) ?: ""
                    companyName = it.getStringOrNull(JSON_KEY_COMPANY_NAME) ?: ""
                    customIntValues = it.getMapOrNull(JSON_KEY_CUSTOM_INT_VALUES) ?: mutableMapOf()
                    customStringValues = it.getMapOrNull(JSON_KEY_CUSTOM_STRING_VALUES) ?: mutableMapOf()
                    customBooleanValues = it.getMapOrNull(JSON_KEY_CUSTOM_BOOLEAN_VALUES) ?: mutableMapOf()
                    customDateValues = it.getMapOrNull(JSON_KEY_CUSTOM_DATE_VALUES) ?: mutableMapOf()
                }
            }
        }

    }

}
