package pl.redlink.push.lifecycle

import android.app.Activity
import android.app.Application
import android.content.ComponentCallbacks2
import android.content.Intent
import android.content.res.Configuration
import android.os.Bundle
import pl.redlink.push.di.redlink
import pl.redlink.push.fcm.NotificationActionBroadcast
import pl.redlink.push.fcm.action.Action
import pl.redlink.push.fcm.action.ActionProcessor
import pl.redlink.push.fcm.action.ActionType


internal class ActivityLifecycleHandler(
        private val lifecycleDelegate: AppLifecycleDelegate = redlink().lifecycleDelegate,
        private val actionProcessor: ActionProcessor = redlink().actionProcessor
) : Application.ActivityLifecycleCallbacks, ComponentCallbacks2, RedlinkLifecycle {

    private var isAppInForeground = false

    override fun onActivityResumed(activity: Activity?) {
        if (!isAppInForeground) {
            isAppInForeground = true
            lifecycleDelegate.onAppInForeground(activity)
        }
    }

    override fun onTrimMemory(level: Int) {
        if (level == ComponentCallbacks2.TRIM_MEMORY_UI_HIDDEN) {
            isAppInForeground = false
            lifecycleDelegate.onAppInBackground()
        }
    }

    override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {
        if (savedInstanceState == null) {
            handleIntent(activity, activity.intent)
        }
    }

    override fun onLowMemory() {
        //no operation required
    }

    override fun onConfigurationChanged(newConfig: Configuration?) {
        //no operation required
    }

    override fun onActivityPaused(activity: Activity?) {
        //no operation required
    }

    override fun onActivityStarted(activity: Activity) {
        //no operation required
    }

    override fun onActivityDestroyed(activity: Activity) {
        //no operation required
    }

    override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle?) {
        //no operation required
    }

    override fun onActivityStopped(activity: Activity) {
        //no operation required
    }

    override fun onNewIntent(activity: Activity, intent: Intent?) {
        handleIntent(activity, intent)
    }

    private fun handleIntent(activity: Activity, intent: Intent?) {
        if (intent?.hasExtra(NotificationActionBroadcast.EXTRA_ACTION) == true) {
            val action = intent.getParcelableExtra<Action>(NotificationActionBroadcast.EXTRA_ACTION)
            intent.removeExtra(NotificationActionBroadcast.EXTRA_ACTION)
            if (action.type == ActionType.WEBVIEW) {
                actionProcessor.runWebview(activity, action)
            }
        }
    }

}
