package pl.redlink.push.http

import pl.redlink.push.extension.empty
import java.io.DataOutputStream
import java.io.IOException
import java.net.HttpURLConnection
import java.nio.charset.StandardCharsets
import javax.net.ssl.HttpsURLConnection

internal class HttpClient {

    fun execute(request: Request): Response {
        val connection = connect(request)
        try {
            connection.apply {
                requestMethod = request.method.value
                request.contentType?.let {
                    if (!it.isBlank()) {
                        setRequestProperty("content-type", it)
                    }
                }
                request.headers.forEach {
                    setRequestProperty(it.key, it.value)
                }
                doOutput = doOutput(request.method)
                request.body?.let {
                    val postData: ByteArray = it.toByteArray(StandardCharsets.UTF_8)
                    val outputStream = DataOutputStream(outputStream)
                    outputStream.write(postData)
                    outputStream.flush()
                }
            }
        } catch (exception: Exception) {
            exception.printStackTrace()
        }
        return try {
            val code = connection.responseCode
            val stream = connection.errorStream ?: connection.inputStream
            Response(
                    url = connection.url.toString(),
                    status = code,
                    stream = stream,
                    headers = connection.headerFields)
        } catch (exception: IOException) {
            Response(
                    url = connection.url.toString(),
                    stream = empty(),
                    error = exception)
        }
    }

    private fun connect(request: Request): HttpURLConnection {
        val urlConnection = request.url.openConnection()
        return if (request.url.protocol == "https") {
            urlConnection as HttpsURLConnection
        } else {
            urlConnection as HttpURLConnection
        }
    }

    private fun doOutput(method: Method): Boolean = when (method) {
        Method.GET -> false
        Method.DELETE, Method.POST, Method.PUT, Method.PATCH -> true
    }

    companion object {

        const val CONTENT_TYPE_JSON = "application/json"

    }

}