package pl.redlink.push.fcm.action

import android.content.Context
import pl.redlink.push.di.redlink
import pl.redlink.push.fcm.RedlinkActionHandler

open class DefaultActionHandler(private val actionProcessor: ActionProcessor = redlink().actionProcessor) : RedlinkActionHandler {

    override fun handleAction(applicationContext: Context, action: Action) {
        when {
            action.type == ActionType.DEEPLINK -> actionProcessor.runDeeplink(applicationContext, action)
            action.type == ActionType.BROWSER -> actionProcessor.runBrowser(applicationContext, action)
            action.type == ActionType.WEBVIEW -> actionProcessor.runApp(applicationContext, action = action)
            action.type == ActionType.NONE -> {
                //do nothing
            }
        }
    }

}