package pl.redlink.push.extension

import android.util.Patterns
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject

fun String?.isEmail(): Boolean =
    !(this?.isBlank() ?: true) && Patterns.EMAIL_ADDRESS.matcher(this).matches()

fun String?.orNullIfBlank(): String? =
    if (this.isNullOrBlank()) null else this

fun String?.isJson(): Boolean? {
    try {
        JSONObject(this)
    } catch (ex: JSONException) {
        try {
            JSONArray(this)
        } catch (ex1: JSONException) {
            return false
        }
    }
    return true
}