package pl.redlink.push.database

import android.provider.BaseColumns

internal object EventsDatabaseTable {

    const val TABLE_NAME = "events"
    const val COLUMN_NAME_ID = BaseColumns._ID
    const val COLUMN_NAME_NAME = "name"
    const val COLUMN_NAME_TIMESTAMP = "timestamp"
    const val COLUMN_NAME_STRING_PARAMETERS = "stringParameters"
    const val COLUMN_NAME_BOOLEAN_PARAMETERS = "booleanParameters"
    const val COLUMN_NAME_INTEGER_PARAMETERS = "integerParameters"
    const val COLUMN_NAME_DATE_PARAMETERS = "dateParameters"
    const val COLUMN_NAME_USER_DATA = "userData"

    const val QUERY_CREATE_TABLE =
            "CREATE TABLE IF NOT EXISTS ${EventsDatabaseTable.TABLE_NAME} (" +
                    "${EventsDatabaseTable.COLUMN_NAME_ID} INTEGER PRIMARY KEY," +
                    "${EventsDatabaseTable.COLUMN_NAME_NAME} TEXT," +
                    "${EventsDatabaseTable.COLUMN_NAME_TIMESTAMP} REAL," +
                    "${EventsDatabaseTable.COLUMN_NAME_STRING_PARAMETERS} BLOB, " +
                    "${EventsDatabaseTable.COLUMN_NAME_BOOLEAN_PARAMETERS} BLOB, " +
                    "${EventsDatabaseTable.COLUMN_NAME_INTEGER_PARAMETERS} BLOB, " +
                    "${EventsDatabaseTable.COLUMN_NAME_DATE_PARAMETERS} BLOB, " +
                    "${EventsDatabaseTable.COLUMN_NAME_USER_DATA} TEXT)"

                    const val QUERY_DROP_TABLE =
            "DROP TABLE IF EXISTS ${EventsDatabaseTable.TABLE_NAME}"

    const val QUERY_CLEAR_TABLE =
            "DELETE FROM ${EventsDatabaseTable.TABLE_NAME}"

}
